package me.emafire003.dev.coloredglowlib.command;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import me.emafire003.dev.coloredglowlib.compat.permissions.PermissionsChecker;
import me.emafire003.dev.coloredglowlib.component.GlobalColorComponent;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import java.util.Collection;

public class ClearGlowColorCommand implements CGLCommand {

    private int resetDefaultColor(CommandContext<class_2168> context) throws CommandSyntaxException {

        class_2168 source = context.getSource();

        if (ColoredGlowLibMod.getAPI() != null) {
            ColoredGlowLibMod.getAPI().clearGlobalColor();
        }else{
            source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§7Resetted the default color to white!"), false);
        return 1;

    }

    private int clearEntityColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection<? extends class_1297> targets = class_2186.method_9317(context, "targets");
        class_2168 source = context.getSource();

        boolean useDefault;
        try{
            useDefault = BoolArgumentType.getBool(context, "useDefaultColor");
        }catch (Exception e){
            useDefault = false;
        }

        for (class_1297 entity : targets) {
            if (ColoredGlowLibMod.getAPI() != null) {
                ColoredGlowLibMod.getAPI().clearColor(entity, useDefault);
            }else{
                source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                return 1;
            }
        }

        source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§7Cleared the color from the selected entity/entities!"), true);
        return targets.size();
    }


    private int clearEntityColorFor(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection<? extends class_1297> targets = class_2186.method_9317(context, "targets");
        class_2168 source = context.getSource();
        class_3222 player = class_2186.method_9315(context, "visibleToPlayer");

        boolean useDefault;
        try{
            useDefault = BoolArgumentType.getBool(context, "useDefaultColor");
        }catch (Exception e){
            useDefault = false;
        }

        for (class_1297 entity : targets) {
            if (ColoredGlowLibMod.getAPI() != null) {
                ColoredGlowLibMod.getAPI().clearExclusiveColorFor(entity, player, useDefault);
            }else{
                source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                return 1;
            }
        }

        source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§7Cleared the color visible only to " + player.method_5477().getString() + "from the selected entity/entities!"), true);
        return targets.size();
    }

    private int clearEntityTypeColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1299<?> type = class_7733.method_45610(context, "entity").comp_349();
        class_2168 source = context.getSource();

        boolean useDefault;
        try{
            useDefault = BoolArgumentType.getBool(context, "useDefaultColor");
        }catch (Exception e){
            useDefault = false;
        }

        if (ColoredGlowLibMod.getAPI() != null) {
            ColoredGlowLibMod.getAPI().clearColor(type, useDefault);
        }else{
            source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
            return 0;
        }

        source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§7Cleared color from the selected entity/entities!"), false);
        return 1;
    }

    private int resetSettings(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();

        if (ColoredGlowLibMod.getAPI() != null) {
            ColoredGlowLibMod.getAPI().setEntityTypeColorOverridesEntityColor(false);
            ColoredGlowLibMod.getAPI().setDefaultOverridesAll(false);
            ColoredGlowLibMod.getAPI().setOverrideTeamColors(false);
        }else{
            source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
            return 0;
        }

        source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§7All settings have been reset to default values!"), false);
        return 1;
    }

    private int resetAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        GlobalColorComponent globalColorComponent = GlobalColorComponent.GLOBAL_COLOR_COMPONENT.get(source.method_9211().method_3845());
        globalColorComponent.clear();

        source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§7All settings and entitytype/default/global colors have been reset to default values!"), false);
        source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§7If you want to clear entity-specifc colors as well use /cgl clear @e!"), false);

        return 1;
    }

    public LiteralCommandNode<class_2168> getNode(class_7157 registryAccess) {
        return class_2170
                .method_9247("clear")
                .requires(PermissionsChecker.hasPerms("coloredglowlib.commands.clearcolor", 2))
                .then(
                        class_2170.method_9244("targets", class_2186.method_9306())
                                .executes(this::clearEntityColor)
                                .then(
                                    class_2170.method_9244("useDefaultColor", BoolArgumentType.bool())
                                .executes(this::clearEntityColor)
                                )
                )
                .then(
                        class_2170.method_9244("targets", class_2186.method_9306())
                                .executes(this::clearEntityColor).then(
                                       class_2170.method_9244("visibleToPlayer", class_2186.method_9308())
                                               .then(
                                                       class_2170.method_9244("useDefaultColor", BoolArgumentType.bool())
                                                               .executes(this::clearEntityColorFor)
                                               )
                                )

                )

                .then(
                        class_2170.method_9244("entity", class_7733.method_45603(registryAccess, class_7924.field_41266)).suggests(class_2321.field_10935)
                                .executes(this::clearEntityTypeColor)
                                .then(
                                        class_2170.method_9244("useDefaultColor", BoolArgumentType.bool())
                                                .executes(this::clearEntityTypeColor)
                                )
                )
                .then(
                        class_2170.method_9247("default")
                                .executes(this::resetDefaultColor)
                ).then(
                        class_2170.method_9247("settings")
                                .executes(this::resetSettings)
                )
                .then(
                        class_2170.method_9247("all")
                                .requires(PermissionsChecker.hasPerms("coloredglowlib.commands.clearcolor.all", 2))
                                .then(
                                class_2170.method_9247("confirm")
                                        .executes(this::resetAll)
                        )

                )
                .build();
    }

}
