package me.emafire003.dev.coloredglowlib.command;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import me.emafire003.dev.coloredglowlib.compat.permissions.PermissionsChecker;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import java.util.Collection;

import static me.emafire003.dev.coloredglowlib.util.ColorUtils.isValidColorOrCustom;

public class SetGlowColorCommand implements CGLCommand {
    

    private int setGlowColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection<? extends class_1297> targets = class_2186.method_9317(context, "targets");
        String color = "#"+StringArgumentType.getString(context, "color");
        class_2168 source = context.getSource();

        if(isValidColorOrCustom(color)){
            for (class_1297 entity : targets) {
                if(color.equalsIgnoreCase("#rainbow")){
                    if (ColoredGlowLibMod.getAPI() != null) {
                        ColoredGlowLibMod.getAPI().setRainbowColor(entity);
                    }else{
                        source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                        return 1;
                    }
                }else if(color.equalsIgnoreCase("#random")){

                    if (ColoredGlowLibMod.getAPI() != null) {
                        ColoredGlowLibMod.getAPI().setRandomColor(entity);
                    }else{
                        source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                        return 1;
                    }
                }else{
                    if (ColoredGlowLibMod.getAPI() != null) {
                        ColoredGlowLibMod.getAPI().setColor(entity, color);
                    }else{
                        source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                        return 1;
                    }
                }
            }

            //source.sendFeedback(new TranslatableText("commands.setglowcolor.success1").append(color).append(new TranslatableText("commands.setglowcolor.success2")), true);
            source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§7Setted color '§b" + color + "§7' to the selected entity/entities!"), false);
            return targets.size();
        }else{
            //source.sendError(new TranslatableText("commands.setglowcolor.notcolor"));
            source.method_9213((class_2561.method_43470(ColoredGlowLibMod.PREFIX+"Error! The value you have specified is not §cvalid! It should be RRGGBB (without '#') or 'rainbow' or 'random' or a custom animation name!")));
            return 0;
        }
    }

    private int setGlowColorFor(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        Collection<? extends class_1297> targets = class_2186.method_9317(context, "targets");
        String color = "#"+StringArgumentType.getString(context, "color");
        class_1657 player = class_2186.method_9315(context, "visibleOnlyToPlayer");


        if(isValidColorOrCustom(color)){
            for (class_1297 entity : targets) {
                if(color.equalsIgnoreCase("#rainbow")){
                    if (ColoredGlowLibMod.getAPI() != null) {
                        ColoredGlowLibMod.getAPI().setExclusiveColorFor(entity, "rainbow", player);
                    }else{
                        source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                        return 1;
                    }
                }else if(color.equalsIgnoreCase("#random")){

                    if (ColoredGlowLibMod.getAPI() != null) {
                        ColoredGlowLibMod.getAPI().setExclusiveColorFor(entity, "random", player);
                    }else{
                        source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                        return 1;
                    }
                }else{
                    if (ColoredGlowLibMod.getAPI() != null) {
                        ColoredGlowLibMod.getAPI().setExclusiveColorFor(entity, color, player);
                    }else{
                        source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                        return 1;
                    }
                }
            }

            //source.sendFeedback(new TranslatableText("commands.setglowcolor.success1").append(color).append(new TranslatableText("commands.setglowcolor.success2")), true);
            source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§7Setted color '§b" + color + "§7' to the selected entity/entities, visible only to §b" + player.method_5477().getString() + "!"), false);
            return targets.size();
        }else{
            //source.sendError(new TranslatableText("commands.setglowcolor.notcolor"));
            source.method_9213((class_2561.method_43470(ColoredGlowLibMod.PREFIX+"Error! The value you have specified is not §cvalid! It should be RRGGBB (without '#') or 'rainbow' or 'random' or a custom animation name!")));
            return 0;
        }
    }

    private int setTypeGlowColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        String color = "#"+StringArgumentType.getString(context, "color");
        class_2168 source = context.getSource();

        if(isValidColorOrCustom(color)){
            class_1299<?> type = class_7733.method_45610(context, "entity").comp_349();
            if(color.equalsIgnoreCase("#rainbow")){
                if (ColoredGlowLibMod.getAPI() != null) {
                    ColoredGlowLibMod.getAPI().setRainbowColor(type);
                }else{
                    source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                    return 1;
                }
            }else if(color.equalsIgnoreCase("#random")){

                if (ColoredGlowLibMod.getAPI() != null) {
                    ColoredGlowLibMod.getAPI().setRandomColor(type);
                }else{
                    source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                    return 1;
                }
            }else{
                if (ColoredGlowLibMod.getAPI() != null) {
                    ColoredGlowLibMod.getAPI().setColor(type, color);
                }else{
                    source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                    return 1;
                }
            }

            //source.sendFeedback(new TranslatableText("commands.setglowcolor.success1").append(color).append(new TranslatableText("commands.setglowcolor.success2")), true);
            source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§7Setted color '" + color + "' to the selected entity/entities!"), false);
            return 1;
        }else{
            //source.sendError(new TranslatableText("commands.setglowcolor.notcolor"));
            source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"Error! The value you have specified is not §cvalid! It should be RRGGBB (without '#') or 'rainbow' or 'random' or a custom animation name!"));
            return 0;
        }
    }


    private int setDefaultGlowColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String color = "#"+StringArgumentType.getString(context, "color");
            class_2168 source = context.getSource();

            if(isValidColorOrCustom(color)){
                if(color.equalsIgnoreCase("#rainbow")){
                    if (ColoredGlowLibMod.getAPI() != null) {
                        ColoredGlowLibMod.getAPI().setGlobalRainbow();
                    }else{
                        source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                        return 1;
                    }
                }else if(color.equalsIgnoreCase("#random")){
                    if (ColoredGlowLibMod.getAPI() != null) {
                        ColoredGlowLibMod.getAPI().setGlobalRandom();
                    }else{
                        source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                        return 1;
                    }
                }else{
                    if (ColoredGlowLibMod.getAPI() != null) {
                        ColoredGlowLibMod.getAPI().setGlobalColor(color);
                    }else{
                        source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                        return 1;
                    }
                }

                source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§7Setted color '§b" + color + "§7' as the default color!"), false);
                return 1;
            }else{
                //source.sendError(new TranslatableText("commands.setglowcolor.notcolor"));
                source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"Error! The value you have specified is not §cvalid! It should be RRGGBB (without '#') or 'rainbow' or 'random' or a custom animation name!"));
                return 0;
            }
        }catch (Exception e){
            e.printStackTrace();
            return 0;
        }

    }

    private int clearEntityColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection<? extends class_1297> targets = class_2186.method_9317(context, "targets");
        boolean useDefault = BoolArgumentType.getBool(context, "useDefaultColor");
        class_2168 source = context.getSource();

        for (class_1297 entity : targets) {
            if (ColoredGlowLibMod.getAPI() != null) {
                ColoredGlowLibMod.getAPI().clearColor(entity, useDefault);
            }else{
                source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
                return 1;
            }
        }

        source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"Cleared the color from the selected entity/entities!"), true);
        return targets.size();
    }

    private int clearEntityTypeColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean useDefault = BoolArgumentType.getBool(context, "useDefaultColor");
        class_1299<?> type = class_7733.method_45610(context, "entity").comp_349();

        class_2168 source = context.getSource();

        if (ColoredGlowLibMod.getAPI() != null) {
            ColoredGlowLibMod.getAPI().clearColor(type, useDefault);
        }else{
            source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
            return 1;
        }

        source.method_9226(() -> class_2561.method_43470(ColoredGlowLibMod.PREFIX+"Cleared color from the selected entity/entities!"), false);
        return 1;
    }

    public LiteralCommandNode<class_2168> getNode(class_7157 registryAccess) {
        return class_2170
                .method_9247("setglowcolor")
                .requires(PermissionsChecker.hasPerms("coloredglowlib.commands.setglowcolor", 2))
                .then(
                        class_2170.method_9244("targets", class_2186.method_9306())
                                .then(
                                    class_2170.method_9244("color", StringArgumentType.string())
                                .executes(this::setGlowColor)
                                )
                )
                .then(
                        class_2170.method_9244("targets", class_2186.method_9306())
                                .then(
                                        class_2170.method_9244("color", StringArgumentType.string())
                                                .then(
                                                        class_2170.method_9244("visibleOnlyToPlayer", class_2186.method_9308()
                                                        ).executes(this::setGlowColorFor)
                                                )

                                )
                )
                .then(
                        class_2170.method_9244("entity", class_7733.method_45603(registryAccess, class_7924.field_41266)).suggests(class_2321.field_10935)
                                .then(
                                        class_2170.method_9244("color", StringArgumentType.string())
                                                .executes(this::setTypeGlowColor)
                                )
                )
                .then(
                        class_2170.method_9247("default")
                                .then(
                                        class_2170.method_9244("color", StringArgumentType.string())
                                                .executes(this::setDefaultGlowColor)
                                )
                )
                .build();
    }

}
