package me.emafire003.dev.coloredglowlib.command;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import me.emafire003.dev.coloredglowlib.compat.permissions.PermissionsChecker;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;


public class SettingsCommand implements CGLCommand {


    // I can't use something like that because the server hasn't started yet when the command is registered, so i need to get the api inside the method call
    // private final ColoredGlowLibAPI cgl = ColoredGlowLibMod.getColoredGlowLib();

    private int setOverrideTeamColors(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean b = BoolArgumentType.getBool(context, "value");
        class_2168 source = context.getSource();

        if (ColoredGlowLibMod.getAPI() != null) {
            ColoredGlowLibMod.getAPI().setOverrideTeamColors(b);
        }else{
            source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
            return 0;
        }

        if(b){
            source.method_9226(() ->class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§aThe color set by the mod will a have priority over the vanilla team color! (Override Team Colors : Enabled) "), true);
        }else{
            source.method_9226(() ->class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cThe color of the vanilla team will have priority over the one set by the mod! (Override Team Colors : Disabled)"), true);
        }
        return 1;
    }

    private int getOverrideTeamColors(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        boolean b = false;
        if (ColoredGlowLibMod.getAPI() != null) {
            b = ColoredGlowLibMod.getAPI().getOverrideTeamColors();
        }else{
            source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
            return 0;
        }

        if(b){
            source.method_9226(() ->class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§aThe color set by the mod has priority over the vanilla team color! (Override Team Colors : Enabled) "), false);
        }else{
            source.method_9226(() ->class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cThe color of the vanilla team has priority over the one set by the mod! (Override Team Colors : Disabled)"), false);
        }
        return 1;
    }

    private int setEntityTypeColorOverridesEntityColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean b = BoolArgumentType.getBool(context, "value");
        class_2168 source = context.getSource();

        if (ColoredGlowLibMod.getAPI() != null) {
           ColoredGlowLibMod.getAPI().setEntityTypeColorOverridesEntityColor(b);
        }else{
            source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
            return 0;
        }

        if(b){
            source.method_9226(() ->class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§aEntityType glow color is now predominant over Entity-specific color! (EntityType >> Entity) "), true);
        }else{
            source.method_9226(() ->class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cEntityType glow color will now be overridden by Entity-specific color! (Entity >> EntityType) "), true);
        }
        return 1;
    }

    private int getEntityTypeColorOverridesEntityColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        boolean b = false;

        if (ColoredGlowLibMod.getAPI() != null) {
            b = ColoredGlowLibMod.getAPI().getEntityTypeColorOverridesEntityColor();
        }else{
            source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
            return 0;
        }

        if(b){
            source.method_9226(() ->class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§aEntityTypes glow color is currently predominant over Entity-specific color. (EntityType >> Entity) "), false);
        }else{
            source.method_9226(() ->class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cEntity glow color is currently predominant over EntityType color. (Entity >> EntityType)"), false);
        }
        return 1;
    }

    private int setGlobalOverridesAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean b = BoolArgumentType.getBool(context, "value");
        class_2168 source = context.getSource();

        if (ColoredGlowLibMod.getAPI() != null) {
            ColoredGlowLibMod.getAPI().setDefaultOverridesAll(b);
        }else{
            source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
            return 0;
        }

        if(b){
            source.method_9226(() ->class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§aGlobal/Default glow color is now predominant over Entity or EntityType colors! (Global >> everything else) "), true);
        }else{
            source.method_9226(() ->class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cEntityType or Entity color is now predominant over Global/Default color! (everything else >> Global) "), true);
        }
        return 1;
    }

    private int getGlobalOverridesAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = context.getSource();
        boolean b = false;

        if (ColoredGlowLibMod.getAPI() != null) {
            b = ColoredGlowLibMod.getAPI().getDefaultOverridesAll();
        }else{
            source.method_9213(class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cAn error has occurred. The API hasn't yet been initialised!"));
            return 0;
        }

        if(b){
            source.method_9226(() ->class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§aGlobal/Default glow color is currently predominant over Entity or EntityType colors! (Global >> everything else) "), false);
        }else{
            source.method_9226(() ->class_2561.method_43470(ColoredGlowLibMod.PREFIX+"§cEntityType or Entity color is currently predominant over Global/Default color! (everything else >> Global)"), false);
        }
        return 1;
    }


//CommandManager.argument("entity", EntitySummonArgumentType.entitySummon()).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).then(((RequiredArgumentBuilder)CommandManager.argument("color", StringArgumentType.string())
     public LiteralCommandNode<class_2168> getNode(class_7157 registryAccess) {
        return class_2170
                .method_9247("settings")
                .requires(PermissionsChecker.hasPerms("coloredglowlib.commands.settings", 2))
                .then(
                        class_2170.method_9247("set")
                                .then(
                                        class_2170.method_9247("globalOverEverything")
                                                .then(
                                                        class_2170.method_9244("value", BoolArgumentType.bool())
                                                                .executes(this::setGlobalOverridesAll)
                                                )
                                )
                )
                .then(
                        class_2170.method_9247("set")
                                .then(
                                        class_2170.method_9247("overrideTeamColors")
                                                .then(
                                                        class_2170.method_9244("value", BoolArgumentType.bool())
                                                                .executes(this::setOverrideTeamColors)
                                                )
                                )
                )
                .then(
                        class_2170.method_9247("set")
                                .then(
                                        class_2170.method_9247("typeOverEntity")
                                                .then(
                                                        class_2170.method_9244("value", BoolArgumentType.bool())
                                                                .executes(this::setEntityTypeColorOverridesEntityColor)
                                                )
                                )
                )
                .then(
                        class_2170.method_9247("get")
                                .then(
                                        class_2170.method_9247("globalOverEverything").executes(this::getGlobalOverridesAll)

                                )
                )
                .then(
                        class_2170.method_9247("get")
                                .then(
                                        class_2170.method_9247("overrideTeamColors").executes(this::getOverrideTeamColors)

                                )
                )
                .then(
                        class_2170.method_9247("get")
                                .then(
                                        class_2170.method_9247("typeOverEntity").executes(this::getEntityTypeColorOverridesEntityColor)

                                )
                )
                .build();
    }

}
