package me.emafire003.dev.coloredglowlib.compat.permissions;

import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import java.util.function.Predicate;

//Based on Factions' code https://github.com/ickerio/factions (MIT license)
public class PermissionsChecker {

    public static final boolean permissions = FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0");

    @SafeVarargs
    public static Predicate<class_2168> multiple(
            Predicate<class_2168>... args) {
        return source -> {
            for (Predicate<class_2168> predicate : args) {
                if (!predicate.test(source))
                    return false;
            }
            return true;
        };
    }

    public static Predicate<class_2168> hasPerms(String permission, int defaultValue) {
        return (source) -> {
            if(!permissions){
                return source.method_9259(2);
            }else {
                return Permissions.check(source, permission, defaultValue);
            }
        };
    }

    public static boolean hasPerms(class_1297 entity, String permission, boolean defValue){
        if(!permissions){
            return defValue;
        }else {
            return Permissions.check(entity, permission, defValue);
        }
    }
}
