package me.emafire003.dev.coloredglowlib.component;

import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.ComponentV3;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import me.emafire003.dev.coloredglowlib.util.ColorUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import java.util.*;

public class ColorComponent implements ComponentV3, AutoSyncedComponent{

    public static final ComponentKey<ColorComponent> COLOR_COMPONENT =
            ComponentRegistry.getOrCreate(ColoredGlowLibMod.getIdentifier("color_component"), ColorComponent.class);

    private final class_1297 self;

    protected String color = ColorUtils.WHITE;
    protected class_2487 exclusiveTargetColorMap = new class_2487();

    public ColorComponent(class_1297 entity) {
        this.self = entity;
    }


    @Override
    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if(tag.method_10545("color")){
            this.color = tag.method_68564("color", "#ffffff"); //means something is VERY wrong
        }else{
            this.color = ColorUtils.WHITE;
        }
        if(tag.method_10545("exclusiveTargetColorMap")){
            this.exclusiveTargetColorMap = tag.method_10562("exclusiveTargetColorMap").get();
        }else{
            this.exclusiveTargetColorMap = new class_2487();
        }
    }

    @Override
    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10582("color", this.color);
        tag.method_10566("exclusiveTargetColorMap", exclusiveTargetColorMap);
    }

    /**
     * @return  A hex color or "rainbow". If no color has been set, returns the default white one*/
    public String getColor(){
        return this.color;
    }

    /**
     * @param color A hex color or "rainbow"*/
    public void setColor(String color) {
        this.color = color;
        COLOR_COMPONENT.sync(self);
    }

    public HashMap<UUID, String> getExclusiveTargetColorMap(){
        HashMap<UUID, String> map = new HashMap<>();
        List<String> keys = new ArrayList<>(this.exclusiveTargetColorMap.method_10541());
        keys.forEach((key) -> {
            UUID uuid = UUID.fromString(key);
            String color = this.exclusiveTargetColorMap.method_68564(key, "#ffffff");
            map.put(uuid, color);
        });
        return map;
    }

    /**
     * @param uuid The uuid of the player that will see the specific color
     * @param color A hex color or "rainbow"*/
    public void addExclusiveColorFor(UUID uuid, String color){
        exclusiveTargetColorMap.method_10582(uuid.toString(), color);
        COLOR_COMPONENT.sync(self);
    }

    /**
     *
     * WARNING! THIS CANNOT BE USED TO CLEAR A TYPE! USE clearExclusiveColor INSTEAD!
     *
     * @param uuid The uuid of the player that will see the specific color
     * @param color A hex color or "rainbow"*/
    public void setExclusiveColorFor(UUID uuid, String color){
        if(exclusiveTargetColorMap.method_10545(uuid.toString())){
            exclusiveTargetColorMap.method_10551(uuid.toString());
        }
        //This other method calls the sync
        addExclusiveColorFor(uuid, color);
    }

    public void clearExclusiveColorFor(UUID uuid){
        exclusiveTargetColorMap.method_10551(uuid.toString());
        COLOR_COMPONENT.sync(self);
    }

    public String getExclusiveColorFor(UUID uuid){
        String color = exclusiveTargetColorMap.method_68564(uuid.toString(), "#ffffff");
        if(color == null || color.equalsIgnoreCase("")){
            return ColorUtils.WHITE;
        }
        return exclusiveTargetColorMap.method_68564(uuid.toString(), "#ffffff");
    }

    public void clear(){
        this.color = ColorUtils.WHITE;
        this.exclusiveTargetColorMap = new class_2487();
        COLOR_COMPONENT.sync(self);
    }
}
