package me.emafire003.dev.coloredglowlib.component;

import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.ComponentV3;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import me.emafire003.dev.coloredglowlib.util.ColorUtils;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_269;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class GlobalColorComponent implements ComponentV3, AutoSyncedComponent{

    public static final ComponentKey<GlobalColorComponent> GLOBAL_COLOR_COMPONENT =
            ComponentRegistry.getOrCreate(ColoredGlowLibMod.getIdentifier("global_color_component"), GlobalColorComponent.class);

    private final class_269 scoreboard;

    protected String default_color = ColorUtils.WHITE;
    protected boolean typeOverridesEntityColor = false;
    protected boolean defaultOverridesAll = false;
    protected boolean overrideTeamColors = false;

    protected class_2487 entityTypeColorMap = new class_2487();

    public GlobalColorComponent(class_269 scoreboard, @Nullable MinecraftServer server) {
        this.scoreboard = scoreboard;
        //this.server = server;
    }

    @Override
    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {

        if(tag.method_10545("defaultColor")){
            this.default_color = tag.method_68564("defaultColor", "#ffffff");
        }else{
            this.default_color = ColorUtils.WHITE;
        }

        if(tag.method_10545("typeOverridesEntityColor")){
            this.typeOverridesEntityColor = tag.method_68566("typeOverridesEntityColor", false);
        }else{
            this.typeOverridesEntityColor = false;
        }

        if(tag.method_10545("defaultOverridesAll")){
            this.defaultOverridesAll= tag.method_68566("defaultOverridesAll", false);
        }else{
            this.defaultOverridesAll = false;
        }

        if(tag.method_10545("overrideTeamColors")){
            this.overrideTeamColors = tag.method_68566("overrideTeamColors", false);
        }else{
            this.overrideTeamColors = false;
        }

        if(tag.method_10545("entityTypeColorMap")){
            this.entityTypeColorMap = tag.method_10562("entityTypeColorMap").get();
        }else{
            this.entityTypeColorMap = new class_2487();
        }
    }

    @Override
    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10582("defaultColor", this.default_color);
        tag.method_10556("typeOverridesEntityColor", this.typeOverridesEntityColor);
        tag.method_10556("defaultOverridesAll", this.defaultOverridesAll);
        tag.method_10556("overrideTeamColors", this.overrideTeamColors);
        tag.method_10566("entityTypeColorMap", this.entityTypeColorMap);
    }


    public HashMap<class_1299<?>, String> getEntityTypeColorMap(){
        HashMap<class_1299<?>, String> map = new HashMap<>();
        List<String> keys = new ArrayList<>(this.entityTypeColorMap.method_10541());
        keys.forEach((key) -> {
            Optional<class_1299<?>> type = class_1299.method_5898(key);
            String color = this.entityTypeColorMap.method_68564(key, "#ffffff");
            type.ifPresent(entityType -> map.put(entityType, color));
        });
        return map;
    }

    /**
     * @param type An entity type
     * @param color A hex color or "rainbow"*/
    public void addEntityTypeColor(class_1299<?> type, String color){
        entityTypeColorMap.method_10582(type.toString(), color);
        GLOBAL_COLOR_COMPONENT.sync(scoreboard);
    }

    /**
     *
     * WARNING! THIS CANNOT BE USED TO CLEAR A TYPE! USE clearEntityTypeColor INSTEAD!
     *
     * @param type An entity type
     * @param color A hex color or "rainbow"*/
    public void setEntityTypeColor(class_1299<?> type, String color){
        if(entityTypeColorMap.method_10545(type.toString())){
            entityTypeColorMap.method_10551(type.toString());
        }
        //This other method calls the sync
        addEntityTypeColor(type, color);
    }

    public void clearEntityTypeColor(class_1299<?> type){
        entityTypeColorMap.method_10551(type.toString());
        GLOBAL_COLOR_COMPONENT.sync(scoreboard);
    }

    public String getEntityTypeColor(class_1299<?> type){
        String color = entityTypeColorMap.method_68564(type.toString(), "#ffffff");
        if(color == null || color.equalsIgnoreCase("")){
            return ColorUtils.WHITE;
        }
        return entityTypeColorMap.method_68564(type.toString(), "#ffffff");
    }

    public String getDefaultColor(){
        return this.default_color;
    }

    public void setDefaultColor(String default_color) {
        this.default_color = default_color;
        GLOBAL_COLOR_COMPONENT.sync(scoreboard);
    }

    public boolean getEntityTypeOverridesEntityColor() {
        return this.typeOverridesEntityColor;
    }

    public void setTypeOverridesEntityColor(boolean b) {
        this.typeOverridesEntityColor = b;
        GLOBAL_COLOR_COMPONENT.sync(scoreboard);
    }

    public boolean getDefaultOverridesAll() {
        return this.defaultOverridesAll;
    }

    public void setDefaultOverridesAll(boolean b) {
        this.defaultOverridesAll = b;
        GLOBAL_COLOR_COMPONENT.sync(scoreboard);
    }

    public boolean getOverrideTeamColors() {
        return this.overrideTeamColors;
    }

    public void setOverrideTeamColors(boolean b) {
        this.overrideTeamColors = b;
        GLOBAL_COLOR_COMPONENT.sync(scoreboard);
    }

    public void clear(){
        this.default_color = ColorUtils.WHITE;
        this.typeOverridesEntityColor = false;
        this.defaultOverridesAll = false;
        this.overrideTeamColors = false;
        this.entityTypeColorMap = new class_2487();
        GLOBAL_COLOR_COMPONENT.sync(scoreboard);
    }
}
