package me.emafire003.dev.coloredglowlib.custom_data_animations;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import me.emafire003.dev.coloredglowlib.networking.ColorAnimationsPayloadS2C;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.io.Reader;
import java.util.Map;

import static me.emafire003.dev.coloredglowlib.ColoredGlowLibMod.getCustomColorAnimations;


public class CGLResourceManager {

    public static String RESOURCE_PATH = "color_animations";

    public static void register(){
        ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new SimpleSynchronousResourceReloadListener() {

            @Override
            public class_2960 getFabricId() {
                return ColoredGlowLibMod.getIdentifier(RESOURCE_PATH);
            }

            @Override
            public void method_14491(class_3300 manager) {
                // Clear Caches Here
                getCustomColorAnimations().clear();

                Map<class_2960, class_3298> resources = manager.method_14488(RESOURCE_PATH, identifier -> identifier.method_12832().endsWith(".json"));

                for(class_2960 id : resources.keySet()) {
                    try {

                        Reader reader = resources.get(id).method_43039();//manager.getResource(id).get().getReader();
                        JsonElement jsonElement = JsonParser.parseReader(reader);

                        DataResult<CustomColorAnimation> result = CustomColorAnimation.CODEC.parse(new Dynamic<>(JsonOps.INSTANCE, jsonElement));

                        ColoredGlowLibMod.LOGGER.debug("Processing file: " + id);

                        CustomColorAnimation groupOutput = result.getOrThrow();

                        ColoredGlowLibMod.loadCustomColorAnimation(groupOutput);

                    } catch(Exception e) {
                        ColoredGlowLibMod.LOGGER.error("Error occurred while loading resource json" + id.toString(), e);
                    }
                }

                //Checks if animation weren't correct, like using "red" instead of "#ff0000" which isn't defined or another wrong color string of sorts
                ColoredGlowLibMod.checkMaybeWrongAnimations();

                if(FabricLoader.getInstance().getEnvironmentType().equals(EnvType.SERVER)){
                    @Nullable MinecraftServer server = ColoredGlowLibMod.getServerInstance();
                    if(server == null){
                        return;
                    }
                    server.method_3760().method_14571()
                            .forEach(player -> ServerPlayNetworking.send(player, new ColorAnimationsPayloadS2C(getCustomColorAnimations())));
                }
            }
        });
    }
}
