package me.emafire003.dev.coloredglowlib.custom_data_animations;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ColorAnimationItem {

    public static final Codec<ColorAnimationItem> CODEC = RecordCodecBuilder.create(
            instance ->
                    instance.group(Codec.STRING.fieldOf("color")
                                            .forGetter(ColorAnimationItem::getColor),
                                    Codec.INT.fieldOf("active_for")
                                            .forGetter(ColorAnimationItem::getActiveFor)
                            )
                            .apply(instance, ColorAnimationItem::new));

    public static final class_9139<ByteBuf, ColorAnimationItem> PACKET_CODEC = new class_9139<>() {
        @Override
        public ColorAnimationItem decode(ByteBuf buf) {
            return new ColorAnimationItem(class_9135.field_48554.decode(buf), class_9135.field_49675.decode(buf));
        }

        @Override
        public void encode(ByteBuf buf, ColorAnimationItem value) {
            class_9135.field_48554.encode(buf, value.color);
            class_9135.field_49675.encode(buf, value.active_for);
        }
    };

    private final String color;
    private final int active_for;


    public ColorAnimationItem(String color, int active_for){
        this.color = color;
        this.active_for = active_for;
    }

    public String getColor() {
        return color;
    }

    public int getActiveFor() {
        return active_for;
    }
}
