package me.emafire003.dev.coloredglowlib.networking;

import io.netty.buffer.ByteBuf;
import me.emafire003.dev.coloredglowlib.custom_data_animations.ColorAnimationItem;
import me.emafire003.dev.coloredglowlib.custom_data_animations.CustomColorAnimation;
import net.minecraft.class_8703;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.ArrayList;
import java.util.List;

public class ListedPacketCodecs {

    public static class_9139<ByteBuf, List<ColorAnimationItem>> ANIMATION_ITEMS = new class_9139<>() {
        @Override
        public List<ColorAnimationItem> decode(ByteBuf buf) {

            int i = class_8703.method_53016(buf);
            List<ColorAnimationItem> animationItems = new ArrayList<>(i);

            for(int j = 0; j < i; ++j) {
                animationItems.add(ColorAnimationItem.PACKET_CODEC.decode(buf));
            }

            return animationItems;
        }

        @Override
        public void encode(ByteBuf buf, List<ColorAnimationItem> list) {
            class_8703.method_53017(buf, list.size());
            list.forEach((colorItem) -> {
                class_9135.field_48554.encode(buf, colorItem.getColor());
                class_9135.field_49675.encode(buf, colorItem.getActiveFor());
            });
        }
    };

    public static class_9139<ByteBuf, List<CustomColorAnimation>> COLOR_ANIMATIONS = new class_9139<>() {
        @Override
        public List<CustomColorAnimation> decode(ByteBuf buf) {

            int i = class_8703.method_53016(buf);
            List<CustomColorAnimation> animations = new ArrayList<>(i);

            for(int j = 0; j < i; ++j) {

                animations.add(CustomColorAnimation.PACKET_CODEC.decode(buf));
            }

            return animations;
        }

        @Override
        public void encode(ByteBuf buf, List<CustomColorAnimation> list) {
            class_8703.method_53017(buf, list.size());
            list.forEach((animation) -> {
                class_9135.field_48554.encode(buf, animation.getName());
                ANIMATION_ITEMS.encode(buf, animation.getColorAnimations());
            });
        }
    };
}
