/*
 * Decompiled with CFR 0.152.
 */
package com.github.chromaticforge.rawinput.config;

import cc.polyfrost.oneconfig.config.Config;
import cc.polyfrost.oneconfig.config.annotations.Button;
import cc.polyfrost.oneconfig.config.annotations.Dropdown;
import cc.polyfrost.oneconfig.config.annotations.Info;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.config.data.InfoType;
import cc.polyfrost.oneconfig.config.data.Mod;
import cc.polyfrost.oneconfig.config.data.ModType;
import com.github.chromaticforge.rawinput.util.MouseUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0006R\u0016\u0010\u0014\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0006R\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/github/chromaticforge/rawinput/config/RawInputConfig;", "Lcc/polyfrost/oneconfig/config/Config;", "<init>", "()V", "", "unixWarning", "Z", "Ljava/lang/Runnable;", "rescanButton", "Ljava/lang/Runnable;", "getRescanButton", "()Ljava/lang/Runnable;", "setRescanButton", "(Ljava/lang/Runnable;)V", "debugRescan", "getDebugRescan", "()Z", "setDebugRescan", "(Z)V", "rawError", "directError", "", "environment", "I", "getEnvironment", "()I", "setEnvironment", "(I)V", "RawInput"})
public final class RawInputConfig
extends Config {
    @NotNull
    public static final RawInputConfig INSTANCE = new RawInputConfig();
    @Info(text="Your operating system does not support Raw Input. Feel free to uninstall this mod.", type=InfoType.WARNING, size=2)
    private static boolean unixWarning;
    @Button(name="Rescan mice", text="Rescan", description="Rescans for new mice.")
    @NotNull
    private static Runnable rescanButton;
    @Switch(name="Show rescans", description="Displays when the mod rescans in chat.")
    private static boolean debugRescan;
    @Info(text="Raw input is not supported, try using the Direct Input Environment or disabling this mod.", type=InfoType.ERROR, size=2, category="Advanced")
    private static boolean rawError;
    @Info(text="Direct input is not supported, try using the Default Input Environment or disabling this mod.", type=InfoType.ERROR, size=2, category="Advanced")
    private static boolean directError;
    @Dropdown(name="Input Environment", options={"Direct & Raw", "Direct", "Default"}, description="The Input Environment plugin used.", category="Advanced")
    private static int environment;

    private RawInputConfig() {
        super(new Mod("RawInput", ModType.UTIL_QOL, "/assets/rawinput/icon.svg"), "rawinput.json");
    }

    @NotNull
    public final Runnable getRescanButton() {
        return rescanButton;
    }

    public final void setRescanButton(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"<set-?>");
        rescanButton = runnable;
    }

    public final boolean getDebugRescan() {
        return debugRescan;
    }

    public final void setDebugRescan(boolean bl) {
        debugRescan = bl;
    }

    public final int getEnvironment() {
        return environment;
    }

    public final void setEnvironment(int n) {
        environment = n;
    }

    private static final void rescanButton$lambda$0() {
        MouseUtilsKt.rescan();
    }

    private static final Boolean _init_$lambda$1() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    private static final Boolean _init_$lambda$2() {
        return !SystemUtils.IS_OS_WINDOWS;
    }

    private static final Boolean _init_$lambda$3() {
        return !SystemUtils.IS_OS_WINDOWS;
    }

    private static final Boolean _init_$lambda$4() {
        return !SystemUtils.IS_OS_WINDOWS;
    }

    private static final Boolean _init_$lambda$5() {
        return environment != 1 || MouseUtilsKt.getDirectSupported();
    }

    private static final Boolean _init_$lambda$6() {
        return environment != 0 || MouseUtilsKt.getRawSupported();
    }

    static {
        rescanButton = RawInputConfig::rescanButton$lambda$0;
        environment = 2;
        INSTANCE.initialize();
        INSTANCE.hideIf("unixWarning", RawInputConfig::_init_$lambda$1);
        INSTANCE.hideIf("rescanButton", RawInputConfig::_init_$lambda$2);
        INSTANCE.hideIf("debugRescan", RawInputConfig::_init_$lambda$3);
        INSTANCE.hideIf("environment", RawInputConfig::_init_$lambda$4);
        INSTANCE.hideIf("directError", RawInputConfig::_init_$lambda$5);
        INSTANCE.hideIf("rawError", RawInputConfig::_init_$lambda$6);
    }
}

