/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.HammockBlock;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class HammockBlockTileRenderer
implements BlockEntityRenderer<HammockTile> {
    private final ModelPart model;
    private final ModelPart ropeF;
    private final ModelPart ropeB;

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("rope_b", CubeListBuilder.m_171558_().m_171514_(32, 56).m_171481_(-8.0f, 0.0f, 0.0f, 16.0f, 8.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)-18.0f, (float)-2.0071f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rope_f", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171481_(-8.0f, -8.0f, 0.0f, 16.0f, 8.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)18.0f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("pillow", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -18.0f, -6.0f, 16.0f, 36.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public HammockBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        this.model = context.m_173582_(SleepTightClient.HAMMOCK);
        this.ropeF = this.model.m_171324_("rope_f");
        this.ropeB = this.model.m_171324_("rope_b");
    }

    public void render(HammockTile blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float zOffset;
        BlockState state = blockEntity.m_58900_();
        HammockPart value = (HammockPart)((Object)state.m_61143_(HammockBlock.PART));
        boolean onRope = value.isOnFence();
        double dy = value.getPivotOffset();
        if (onRope) {
            zOffset = -0.5f;
            this.ropeB.f_104203_ = -2.6179938f;
            this.ropeF.f_104203_ = -0.5235988f;
        } else {
            zOffset = 0.0f;
            this.ropeB.f_104203_ = -2.268928f;
            this.ropeF.f_104203_ = -0.8726647f;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5 + dy, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-((Direction)state.m_61143_((Property)HammockBlock.f_54117_)).m_122435_()));
        float yaw = blockEntity.getRoll(partialTick);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f + yaw));
        poseStack.m_85837_(0.0, 0.5 + dy, (double)zOffset);
        Material material = SleepTightClient.HAMMOCK_TEXTURES[blockEntity.getColor().m_41060_()];
        VertexConsumer vertexConsumer = material.m_119194_(bufferSource, RenderType::m_110458_);
        this.model.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
        poseStack.m_85849_();
    }

    private static void renderDebugPivot(PoseStack poseStack, MultiBufferSource bufferSource) {
        VertexConsumer pBuffer = bufferSource.m_6299_(RenderType.m_110504_());
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        pBuffer.m_252986_(matrix4f, 0.0f, 0.0f, -1.0f).m_6122_(255, 0, 255, 255).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        pBuffer.m_252986_(matrix4f, 0.0f, 0.0f, 2.0f).m_6122_(255, 0, 255, 255).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

