/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.client.InfestedBedBakedModel;
import net.mehvahdjukaar.sleep_tight.client.particles.BedbugParticle;
import net.mehvahdjukaar.sleep_tight.client.particles.DreamParticle;
import net.mehvahdjukaar.sleep_tight.client.particles.MimimiParticle;
import net.mehvahdjukaar.sleep_tight.client.renderers.BedbugEntityRenderer;
import net.mehvahdjukaar.sleep_tight.client.renderers.HammockBlockTileRenderer;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SleepTightClient {
    public static final ModelLayerLocation NIGHT_BAG = SleepTightClient.loc("night_bag");
    public static final ModelLayerLocation HAMMOCK = SleepTightClient.loc("hammock");
    public static final ModelLayerLocation BEDBUG = SleepTightClient.loc("bedbug");
    public static final ResourceLocation BED_SHEET = ResourceLocation.withDefaultNamespace((String)"textures/atlas/beds.png");
    public static final ResourceLocation ICONS = SleepTight.res("textures/gui/sleep_icons.png");
    public static final ResourceLocation BEDBUG_TEXTURE = SleepTight.res("textures/entity/bedbug.png");
    public static final ResourceLocation SLEEPING_VILLAGER_TEXTURE = SleepTight.res("textures/entity/villager_sleeping.png");
    public static final Material[] HAMMOCK_TEXTURES = (Material[])Arrays.stream(DyeColor.values()).sorted(Comparator.comparingInt(DyeColor::getId)).map(dyeColor -> new Material(BED_SHEET, SleepTight.res("entity/bed/hammock_" + dyeColor.getName()))).toArray(Material[]::new);
    public static boolean HAS_SNORE = Calendar.getInstance().get(2) == 3 && Calendar.getInstance().get(5) == 1;
    private static long lastTick = 0L;
    private static boolean hasDreamEssenceInRange = false;

    public static void init() {
        ClientHelper.addModelLayerRegistration(SleepTightClient::registerLayers);
        ClientHelper.addEntityRenderersRegistration(SleepTightClient::registerEntityRenderers);
        ClientHelper.addBlockEntityRenderersRegistration(SleepTightClient::registerBlockEntityRenderers);
        ClientHelper.addParticleRegistration(SleepTightClient::registerParticles);
        ClientHelper.addModelLoaderRegistration(SleepTightClient::registerModelLoaders);
    }

    private static ModelLayerLocation loc(String name) {
        return new ModelLayerLocation(SleepTight.res(name), name);
    }

    private static void registerParticles(ClientHelper.ParticleEvent event) {
        event.register((ParticleType)SleepTight.DREAM_PARTICLE.get(), DreamParticle.Factory::new);
        event.register((ParticleType)SleepTight.BEDBUG_PARTICLE.get(), BedbugParticle.Factory::new);
        event.register((ParticleType)SleepTight.ZZZ_PARTICLE.get(), MimimiParticle.Factory::new);
    }

    private static void registerLayers(ClientHelper.ModelLayerEvent event) {
        event.register(HAMMOCK, HammockBlockTileRenderer::createLayer);
        event.register(BEDBUG, BedbugEntityRenderer::createLayer);
    }

    private static void registerEntityRenderers(ClientHelper.EntityRendererEvent event) {
        event.register(SleepTight.BED_ENTITY.get(), NoopRenderer::new);
        event.register(SleepTight.DREAMER_ESSENCE_ENTITY.get(), NoopRenderer::new);
        event.register((EntityType)SleepTight.BEDBUG_ENTITY.get(), BedbugEntityRenderer::new);
    }

    private static void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        event.register(SleepTight.HAMMOCK_TILE.get(), HammockBlockTileRenderer::new);
    }

    private static void registerModelLoaders(ClientHelper.ModelLoaderEvent event) {
        event.register(SleepTight.res("infested_bed"), (CustomModelLoader)new InfestedBedBakedModel.Loader());
    }

    public static Player getPlayer() {
        return Minecraft.getInstance().player;
    }

    public static void onEntityTick(LivingEntity entity) {
        if (entity.isSleeping() && ClientConfigs.ZZZ_PARTICLES.get().booleanValue() && !entity.getType().is(SleepTight.NO_SLEEP_PARTICLES) && entity.tickCount % 35 == 0) {
            BlockState bedState;
            Vec3 pos = entity.position().add(0.0, (double)(entity.getEyeHeight() + 0.0625f), 0.0);
            Level level = entity.level();
            float yawDeg = 180.0f - entity.getViewYRot(1.0f);
            Optional bedPos = entity.getSleepingPos();
            if (bedPos.isPresent() && (bedState = level.getBlockState((BlockPos)bedPos.get())).hasProperty((Property)BedBlock.FACING)) {
                yawDeg = -((Direction)bedState.getValue((Property)BedBlock.FACING)).toYRot();
            }
            level.addParticle((ParticleOptions)SleepTight.ZZZ_PARTICLE.get(), pos.x, pos.y, pos.z, (double)yawDeg, (double)entity.getId(), 0.0);
        }
    }

    @Nullable
    public static BedData getLayingBedData() {
        Player player = SleepTightClient.getPlayer();
        Entity vehicle = player.getVehicle();
        if (vehicle instanceof BedEntity) {
            BedEntity be = (BedEntity)vehicle;
            BlockPos pos = be.blockPosition();
            return STPlatStuff.getBedData(player.level(), pos);
        }
        return null;
    }

    public static boolean getCachedDreamEssenceInRange(BlockPos pos, Level level) {
        if (level.getGameTime() != lastTick) {
            hasDreamEssenceInRange = DreamEssenceBlock.isInRangeInternal(pos, level);
            lastTick = level.getGameTime();
        }
        return hasDreamEssenceInRange;
    }
}

