/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.SleepEffectsHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ClientEvents {
    public static boolean cameraHack;

    public static <T extends LivingEntity> void rotatePlayerInBed(T entity, PoseStack poseStack, float partialTicks, MultiBufferSource bufferSource) {
        Direction dir;
        BlockPos pos = null;
        Optional p = entity.getSleepingPos();
        BedEntity bedEntity = null;
        if (p.isPresent()) {
            pos = (BlockPos)p.get();
        } else {
            Entity entity2 = entity.getVehicle();
            if (entity2 instanceof BedEntity) {
                BedEntity be = (BedEntity)entity2;
                pos = be.getOnPos();
                bedEntity = be;
            }
        }
        if (pos == null) {
            return;
        }
        Level level = entity.level();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HammockTile) {
            HammockTile tile = (HammockTile)blockEntity;
            float roll = tile.getRoll(partialTicks);
            float o = tile.getPivotOffset();
            o = (float)((double)o + 0.125);
            Vector3f v = tile.getDirection().step();
            poseStack.translate(0.0f, o, 0.0f);
            poseStack.mulPose(Axis.of((Vector3f)v).rotationDegrees(roll));
            poseStack.translate(0.0f, -o, 0.0f);
            Minecraft mc = Minecraft.getInstance();
            if (bedEntity != null) {
                float f1 = 90.0f - tile.getDirection().toYRot();
                poseStack.mulPose(Axis.YP.rotationDegrees(f1));
                poseStack.translate(1.51875, 0.125, 0.0);
            } else if (entity == mc.player) {
                poseStack.translate(0.0, 0.125, 0.0);
            }
        } else if (bedEntity != null && (dir = BedBlock.getBedOrientation((BlockGetter)level, (BlockPos)pos)) != null) {
            float f1 = 90.0f - dir.toYRot();
            poseStack.mulPose(Axis.YP.rotationDegrees(f1));
            poseStack.translate(1.5, 0.0, 0.0);
        }
    }

    public static void rotateCameraOverHammockAxis(float partialTicks, PoseStack matrixStack, Camera camera) {
        Player p;
        Minecraft mc = Minecraft.getInstance();
        Entity e = mc.getCameraEntity();
        if (e == null || !mc.options.getCameraType().isFirstPerson()) {
            return;
        }
        double intensity = ClientConfigs.CAMERA_ROLL_INTENSITY.get();
        if (intensity == 0.0) {
            return;
        }
        BlockPos pos = null;
        boolean onBedEntity = false;
        Entity entity = e.getVehicle();
        if (entity instanceof BedEntity) {
            BedEntity bed = (BedEntity)entity;
            onBedEntity = true;
            pos = bed.getOnPos();
        } else if (e instanceof Player) {
            p = (Player)e;
            pos = p.getSleepingPos().orElse(null);
        }
        if (pos != null && (p = e.level().getBlockEntity(pos)) instanceof HammockTile) {
            HammockTile tile = (HammockTile)p;
            Quaternionf q = new Quaternionf((Quaternionfc)camera.rotation());
            q.conjugate();
            matrixStack.mulPose(q);
            float roll = -((float)((double)tile.getRoll(partialTicks) * intensity));
            float o = 0.375f - tile.getPivotOffset();
            matrixStack.translate(0.0f, -o, 0.0f);
            matrixStack.mulPose(Axis.of((Vector3f)tile.getDirection().step()).rotationDegrees(roll));
            matrixStack.translate(0.0f, o, 0.0f);
            matrixStack.mulPose(camera.rotation());
        }
        if (onBedEntity) {
            matrixStack.translate(0.0, -0.3, 0.0);
        }
    }

    public static void onSleepStarted(Entity entity, BlockState state, BlockPos pos) {
        Player player;
        BlockPos partnerPos;
        if (entity instanceof Player && (partnerPos = SleepEffectsHelper.getPartnerPos(player = (Player)entity, state, pos)) != null) {
            entity.level().addParticle((ParticleOptions)ParticleTypes.HEART, 0.5 + (double)((float)(pos.getX() + partnerPos.getX()) / 2.0f), 0.6 + (double)((float)(pos.getY() + partnerPos.getY()) / 2.0f), 0.5 + (double)((float)(pos.getZ() + partnerPos.getZ()) / 2.0f), 0.0, 0.0, 0.0);
        }
    }

    public static void displayRidingMessage(BedEntity bed) {
        Minecraft mc = Minecraft.getInstance();
        if (!CommonConfigs.SLEEP_IMMEDIATELY.get().booleanValue()) {
            MutableComponent component = bed.getRidingMessage(mc.options.keyJump.getTranslatedKeyMessage(), mc.options.keyShift.getTranslatedKeyMessage());
            mc.gui.setOverlayMessage((Component)component, false);
            mc.getNarrator().sayNow((Component)component);
        }
    }
}

