/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.items.NightBagItem;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SleepGuiOverlay
extends Gui
implements LayeredDraw.Layer {
    private static final ResourceLocation BACKGROUND = ResourceLocation.withDefaultNamespace((String)"boss_bar/white_background");
    private static final ResourceLocation PROGRESS = ResourceLocation.withDefaultNamespace((String)"boss_bar/white_progress");
    private static final ResourceLocation OVERLAY_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_6_background");
    private static final ResourceLocation OVERLAY_PROGRESS = ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_6_progress");

    public SleepGuiOverlay(Minecraft minecraft) {
        super(minecraft);
    }

    public void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        Options options = mc.options;
        BedData bedData = SleepTightClient.getLayingBedData();
        LocalPlayer player = mc.player;
        if (bedData != null) {
            PlayerSleepData playerData = STPlatStuff.getPlayerSleepData((Player)player);
            SleepGuiOverlay.renderBar(graphics, bedData, playerData, mc, (Player)player, deltaTracker.getGameTimeDeltaTicks());
            return;
        }
        HitResult hit = mc.hitResult;
        boolean cooldown = ClientConfigs.INSOMNIA_COOLDOWN.get();
        boolean timer = ClientConfigs.INSOMNIA_TIMER.get();
        if (!timer && !cooldown) {
            return;
        }
        this.renderCooldownCrossAir(graphics, options, mc, hit, (Player)player, cooldown, timer);
    }

    private void renderCooldownCrossAir(GuiGraphics graphics, Options options, Minecraft mc, HitResult hit, Player player, boolean cooldown, boolean timer) {
        PlayerSleepData playerData;
        float insomniaPerc;
        BlockHitResult bh;
        boolean laying;
        if (options.getCameraType().isFirstPerson() && (mc.gameMode.getPlayerMode() != GameType.SPECTATOR || this.canRenderCrosshairForSpectator(hit)) && ((laying = player.getVehicle() instanceof BedEntity) || cooldown && (hit instanceof BlockHitResult && mc.level.getBlockState((bh = (BlockHitResult)hit).getBlockPos()).getBlock() instanceof ISleepTightBed || player.getMainHandItem().getItem() instanceof NightBagItem)) && (insomniaPerc = 1.0f - (playerData = STPlatStuff.getPlayerSleepData(player)).getInsomniaCooldownPercentage(player)) < 1.0f) {
            if (laying && timer) {
                graphics.drawString(mc.font, "" + playerData.getInsomniaCooldown(player) / 20L, 2, 2, 0xE0E0E0);
            }
            if (cooldown) {
                this.setupOverlayRenderState(graphics, true, false, SleepTightClient.ICONS);
                graphics.pose().pushPose();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int py = graphics.guiHeight() / 2 - 7 + 16;
                int px = graphics.guiWidth() / 2 - 6;
                if (mc.options.attackIndicator().get() == AttackIndicatorStatus.CROSSHAIR && player.getAttackStrengthScale(0.0f) != 1.0f) {
                    py += 8;
                }
                int l = (int)(insomniaPerc * 11.0f);
                graphics.blit(SleepTightClient.ICONS, px, py, 3.0f, 18.0f, 11, 5, 48, 48);
                graphics.blit(SleepTightClient.ICONS, px, py, 19.0f, 18.0f, l, 5, 48, 48);
                graphics.pose().popPose();
                RenderSystem.defaultBlendFunc();
            }
        }
    }

    protected void setupOverlayRenderState(GuiGraphics graphics, boolean blend, boolean depthTest, ResourceLocation texture) {
    }

    public static void renderBedScreenOverlay(InBedChatScreen s, GuiGraphics graphics, int mouseX, int mouseY) {
        int dx;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        BlockPos sleepingPos = player.getSleepingPos().orElse(null);
        if (sleepingPos == null) {
            return;
        }
        PlayerSleepData playerData = STPlatStuff.getPlayerSleepData((Player)player);
        BedData bedData = STPlatStuff.getBedData(player.level(), sleepingPos);
        if (bedData == null) {
            return;
        }
        boolean hasDreamerEssence = DreamEssenceBlock.isInRange(sleepingPos, player.level());
        boolean isMaxFamiliar = playerData.isBedFamiliarityMaxed(bedData);
        if (ClientConfigs.SHOW_TIME.get().booleanValue()) {
            graphics.drawString(mc.font, SleepGuiOverlay.getCurrentTime(player.level()), 2, 2, 0xE0E0E0);
        }
        int y = s.height - 39;
        int iconSize = 18;
        int bx = s.width / 2 - 120;
        int bh = isMaxFamiliar ? 0 : 28;
        graphics.blit(SleepTightClient.ICONS, bx, y, 0.0f, (float)bh, iconSize, iconSize, 48, 48);
        if (hasDreamerEssence) {
            int x = s.width / 2 + 120 - iconSize;
            graphics.blit(SleepTightClient.ICONS, x, y, (float)iconSize, 0.0f, iconSize, iconSize, 48, 48);
        }
        if (MthUtils.isWithinRectangle((int)bx, (int)y, (int)iconSize, (int)iconSize, (int)mouseX, (int)mouseY)) {
            double nightmare = playerData.getNightmareChance((Player)player, sleepingPos);
            byte bedLevel = bedData.getBedLevel((Player)player);
            MutableComponent title = isMaxFamiliar ? Component.translatable((String)"gui.sleep_tight.home_bed") : Component.translatable((String)"gui.sleep_tight.bed");
            ArrayList lines = new ArrayList(mc.font.split((FormattedText)title, 200));
            if (!isMaxFamiliar) {
                String percent = String.format("%.1f", Float.valueOf(playerData.getBedFamiliarity(bedData) * 100.0f)) + "%";
                lines.addAll(mc.font.split((FormattedText)Component.translatable((String)"gui.sleep_tight.familiarity", (Object[])new Object[]{percent}), 200));
            }
            if (PlatHelper.isDev()) {
                lines.addAll(mc.font.split((FormattedText)Component.literal((String)("LastId Bits: " + String.valueOf(bedData.getId()))), 400));
            }
            lines.addAll(mc.font.split((FormattedText)Component.translatable((String)"gui.sleep_tight.bed_level", (Object[])new Object[]{(int)bedLevel}), 200));
            lines.addAll(mc.font.split((FormattedText)Component.translatable((String)"gui.sleep_tight.nightmare", (Object[])new Object[]{nightmare}), 200));
            graphics.renderTooltip(mc.font, lines, mouseX, mouseY);
        }
        if (hasDreamerEssence && MthUtils.isWithinRectangle((int)(dx = s.width / 2 + 120 - iconSize), (int)y, (int)iconSize, (int)iconSize, (int)mouseX, (int)mouseY)) {
            graphics.renderTooltip(mc.font, mc.font.split((FormattedText)Component.translatable((String)"gui.sleep_tight.dreamer_essence"), 200), mouseX, mouseY);
        }
    }

    private static void renderBar(GuiGraphics graphics, BedData bedData, PlayerSleepData playerData, Minecraft mc, Player player, float partialTicks) {
        int screenHeight = graphics.guiHeight();
        int screenWidth = graphics.guiWidth();
        int xpBarLeft = screenWidth / 2 - 91;
        float familiarity = playerData.getBedFamiliarity(bedData);
        boolean hasDreamerEssence = DreamEssenceBlock.isInRange(player.blockPosition(), player.level());
        double nightmareChance = playerData.getNightmareChance(player, player.blockPosition());
        int barColor = hasDreamerEssence ? 13185173 : 14461959;
        HSVColor color = new RGBColor(barColor).asHSV();
        if (!hasDreamerEssence) {
            float desaturation = (float)(1.0 - nightmareChance * 0.5);
            color = color.withSaturation(color.saturation() * desaturation).withValue(color.value() * desaturation);
        }
        RGBColor rgb = color.asRGB();
        RenderSystem.setShaderColor((float)rgb.red(), (float)rgb.green(), (float)rgb.blue(), (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        int k = (int)(familiarity * 183.0f);
        int xpBarTop = screenHeight - 32 + 3;
        graphics.blitSprite(BACKGROUND, xpBarLeft, xpBarTop, 183, 5);
        graphics.blitSprite(PROGRESS, xpBarLeft, xpBarTop, k, 5);
        graphics.blitSprite(OVERLAY_PROGRESS, xpBarLeft, xpBarTop, 182, 5);
        RenderSystem.disableBlend();
        byte power = bedData.getBedLevel(player);
        boolean bedFamiliarityMaxed = playerData.isBedFamiliarityMaxed(bedData);
        int textCol = hasDreamerEssence ? (bedFamiliarityMaxed ? 12338943 : 6301312) : (bedFamiliarityMaxed ? 57855 : 1598581);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String bedLevelStr = String.valueOf(power);
        int cx = (screenWidth - mc.font.width(bedLevelStr)) / 2;
        int cy = screenHeight - 31 - 4;
        graphics.drawString(mc.font, bedLevelStr, cx + 1, cy, 0, false);
        graphics.drawString(mc.font, bedLevelStr, cx - 1, cy, 0, false);
        graphics.drawString(mc.font, bedLevelStr, cx, cy + 1, 0, false);
        graphics.drawString(mc.font, bedLevelStr, cx, cy - 1, 0, false);
        graphics.drawString(mc.font, bedLevelStr, cx, cy, textCol, false);
    }

    private static Component getCurrentTime(Level level) {
        int time = (int)(level.getDayTime() + 6000L) % 24000;
        int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
        int h = time / 1000;
        String a = "";
        if (!ClientConfigs.TIME_FORMAT_24H.get().booleanValue()) {
            String string = a = time < 12000 ? " AM" : " PM";
            if ((h %= 12) == 0) {
                h = 12;
            }
        }
        return Component.literal((String)(h + ":" + (m < 10 ? "0" : "") + m + a));
    }
}

