/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client.particles;

import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.core.client.MLRenderTypes;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DreamParticle
extends TextureSheetParticle {
    private static final int FADE_START = 40;
    private float maxAlpha;
    private final float deltaRot;
    private final ParticleRenderType renderType;

    protected DreamParticle(ClientLevel clientLevel, double x, double y, double z, double vx, double vy, double vz) {
        super(clientLevel, x, y, z, vx, vy, vz);
        float g = 0.4f + this.random.nextFloat() * 0.25f;
        this.rCol = Math.max(0.0f, Mth.sin((float)((g + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.gCol = Math.max(0.0f, Mth.sin((float)((g + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.bCol = Math.max(0.0f, Mth.sin((float)((g + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        int l = ClientConfigs.PARTICLE_LIFETIME.get();
        this.lifetime = l + (int)MthUtils.nextWeighted((RandomSource)this.random, (float)((float)l * 0.6f), (float)1.0f);
        this.alpha = 0.01f;
        this.deltaRot = (0.002f + MthUtils.nextWeighted((RandomSource)this.random, (float)0.05f, (float)10.0f)) * (float)(this.random.nextBoolean() ? -1 : 1);
        this.quadSize = 0.04f + MthUtils.nextWeighted((RandomSource)this.random, (float)0.08f, (float)200.0f);
        this.roll = (float)(Math.PI * (double)this.random.nextFloat());
        this.friction = 0.995f;
        this.gravity = 0.0f;
        this.xd *= 0.005;
        this.xd += vx;
        this.zd *= 0.005;
        this.zd += vz;
        this.yd = vy;
        this.setSize(0.05f, 0.05f);
        this.maxAlpha = (float)ClientConfigs.PARTICLE_ALPHA.get().doubleValue();
        this.renderType = MLRenderTypes.PARTICLE_ADDITIVE_TRANSLUCENCY_RENDER_TYPE;
    }

    public ParticleRenderType getRenderType() {
        return this.renderType;
    }

    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        this.roll += this.deltaRot;
        int timeLeft = this.lifetime - this.age;
        if (this.age < 40) {
            this.alpha += this.maxAlpha / 40.0f;
            this.alpha = Math.min(this.alpha, this.maxAlpha);
        } else if (timeLeft < 40) {
            this.alpha = this.maxAlpha * (float)timeLeft / 40.0f;
        }
    }

    protected int getLightColor(float partialTick) {
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (!this.level.hasChunkAt(pos)) {
            return 0;
        }
        int i = this.level.getBrightness(LightLayer.SKY, pos);
        int j = this.level.getBrightness(LightLayer.BLOCK, pos);
        if (j < 10) {
            j = 10;
        }
        return i << 20 | j << 4;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType pType, ClientLevel level, double pX, double pY, double pZ, double period, double unused, double mode) {
            DreamParticle p;
            if (mode == 1.0) {
                float h = (float)period;
                float ampl = 0.001f;
                float dx = ampl * Mth.sin((float)((float)Math.PI * 2 * h));
                float dz = ampl * Mth.cos((float)((float)Math.PI * 2 * h));
                float vy = 0.003f + MthUtils.nextWeighted((RandomSource)level.random, (float)0.004f, (float)10.0f);
                p = new DreamParticle(level, pX, pY, pZ, dx, vy, dz);
            } else if (mode == 2.0) {
                float yaw = level.random.nextFloat() * 2.0f * (float)Math.PI;
                float pitch = Mth.randomBetween((RandomSource)level.random, (float)-0.1f, (float)0.5f) * (float)Math.PI;
                float len = 0.4f + level.random.nextFloat() * 0.3f;
                Vec3 v = new Vec3(0.0, 0.0, (double)len).xRot(pitch).yRot(yaw);
                p = new DreamParticle(level, pX + v.x * 0.5, pY + v.y * 0.5, pZ + v.z * 0.5, v.x, v.y * 0.75, v.z);
                p.friction = 0.78f;
                p.maxAlpha *= 2.0f;
                p.alpha = p.maxAlpha;
                p.setLifetime(60 + level.random.nextInt(180));
            } else {
                p = new DreamParticle(level, pX, pY, pZ, period, unused, mode);
            }
            p.setSpriteFromAge(this.sprite);
            return p;
        }
    }
}

