/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MimimiParticle
extends TextureSheetParticle {
    private static final int FADE_START = 40;
    private final float yaw;
    @Nullable
    private final Entity owner;
    private float oQuadSize;
    private float quadInc;
    private float rollOffset;

    public MimimiParticle(ClientLevel clientLevel, double x, double y, double z, double yaw, double entityId, double _b) {
        super(clientLevel, x, y, z, 0.0, 0.0, 0.0);
        this.friction = 1.0f;
        this.gravity = 0.0f;
        this.yaw = (float)yaw;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.oQuadSize = this.quadSize = 0.01f;
        this.quadInc = 0.0019f;
        this.lifetime = 140;
        this.hasPhysics = true;
        this.oRoll = this.roll = Mth.sin((float)((float)this.age / (float)this.lifetime * 3.6f * (float)Math.PI + this.rollOffset)) * 0.1f;
        this.rollOffset = Mth.randomBetween((RandomSource)this.random, (float)0.0f, (float)((float)Math.PI * 2));
        this.owner = clientLevel.getEntity((int)entityId);
    }

    public float getQuadSize(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.oQuadSize, (float)this.quadSize);
    }

    public void tick() {
        LivingEntity le;
        Entity entity;
        this.oRoll = this.roll;
        this.roll = Mth.sin((float)((float)this.age / (float)this.lifetime * 3.6f * (float)Math.PI + this.rollOffset)) * 0.1f;
        float wobble = Mth.cos((float)((float)this.age / (float)this.lifetime * 2.7f * (float)Math.PI)) * 0.006f;
        Vector3f vv = new Vector3f(wobble, 0.0f, 0.0045f);
        vv.rotateY(this.yaw * ((float)Math.PI / 180) - 45.0f);
        this.xd = vv.x();
        this.yd = 0.004;
        this.zd = vv.z();
        this.oQuadSize = this.quadSize;
        this.quadSize += this.quadInc;
        this.quadInc *= 0.98f;
        int timeLeft = this.lifetime - this.age;
        if (timeLeft < 40) {
            this.alpha = (float)timeLeft / 40.0f;
        }
        if (!(this.owner == null || (entity = this.owner) instanceof LivingEntity && (le = (LivingEntity)entity).isSleeping() || timeLeft <= 40)) {
            this.age = this.lifetime - 40;
        }
        super.tick();
    }

    public void move(double dx, double dy, double dz) {
        double wantedX = this.x + dx;
        double wantedY = this.y + dy;
        double wantedZ = this.z + dz;
        super.move(dx, dy, dz);
        boolean collided = Math.abs(this.x - wantedX) > 0.001 || Math.abs(this.y - wantedY) > 0.001 || Math.abs(this.z - wantedZ) > 0.001;
        int timeLeft = this.lifetime - this.age;
        if (collided) {
            this.hasPhysics = false;
            this.x = wantedX;
            this.y = wantedY;
            this.z = wantedZ;
            if (timeLeft > 40) {
                this.age = this.lifetime - 40;
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            MimimiParticle particle = new MimimiParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

