/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.HammockBlock;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HammockBlockTileRenderer
implements BlockEntityRenderer<HammockTile> {
    private final ModelPart model;
    private final ModelPart ropeF;
    private final ModelPart ropeB;

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("rope_b", CubeListBuilder.create().texOffs(32, 56).addBox(-8.0f, 0.0f, 0.0f, 16.0f, 8.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-18.0f, (float)-2.0071f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rope_f", CubeListBuilder.create().texOffs(32, 48).addBox(-8.0f, -8.0f, 0.0f, 16.0f, 8.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)18.0f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("pillow", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -18.0f, -6.0f, 16.0f, 36.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public HammockBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        this.model = context.bakeLayer(SleepTightClient.HAMMOCK);
        this.ropeF = this.model.getChild("rope_f");
        this.ropeB = this.model.getChild("rope_b");
    }

    public void render(HammockTile blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float zOffset;
        BlockState state = blockEntity.getBlockState();
        HammockPart value = (HammockPart)((Object)state.getValue(HammockBlock.PART));
        boolean onRope = value.isOnFence();
        double dy = value.getPivotOffset();
        if (onRope) {
            zOffset = -0.5f;
            this.ropeB.xRot = -2.6179938f;
            this.ropeF.xRot = -0.5235988f;
        } else {
            zOffset = 0.0f;
            this.ropeB.xRot = -2.268928f;
            this.ropeF.xRot = -0.8726647f;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5 + dy, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(-((Direction)state.getValue((Property)HammockBlock.FACING)).toYRot()));
        float yaw = blockEntity.getRoll(partialTick);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f + yaw));
        poseStack.translate(0.0, 0.5 + dy, (double)zOffset);
        Material material = SleepTightClient.HAMMOCK_TEXTURES[blockEntity.getColor().getId()];
        VertexConsumer vertexConsumer = material.buffer(bufferSource, RenderType::entityCutoutNoCull);
        this.model.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    private static void renderDebugPivot(PoseStack poseStack, MultiBufferSource bufferSource) {
        VertexConsumer pBuffer = bufferSource.getBuffer(RenderType.lines());
        PoseStack.Pose pose = poseStack.last();
        pBuffer.addVertex(pose, 0.0f, 0.0f, -1.0f).setColor(255, 0, 255, 255).setNormal(pose, 0.0f, 1.0f, 0.0f);
        pBuffer.addVertex(pose, 0.0f, 0.0f, 2.0f).setColor(255, 0, 255, 255).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

