/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.entities;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundParticleMessage;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DreamerEssenceTargetEntity
extends LivingEntity {
    public DreamerEssenceTargetEntity(Level level, BlockPos pos) {
        super(SleepTight.DREAMER_ESSENCE_ENTITY.get(), level);
        this.setPos(Vec3.atBottomCenterOf((Vec3i)pos));
    }

    public DreamerEssenceTargetEntity(EntityType<? extends LivingEntity> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    public boolean isAttackable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity entity) {
        return true;
    }

    public void tick() {
        Level level = this.level();
        if (level.getBlockState(this.blockPosition()).getBlock() != SleepTight.DREAMER_ESSENCE.get()) {
            this.discard();
        }
        if (level.isClientSide && (double)this.random.nextFloat() < ClientConfigs.PARTICLE_SPAWN_FREQUENCY.get() && Minecraft.getInstance().cameraEntity.distanceToSqr((Entity)this) < 900.0) {
            BlockPos pos = this.blockPosition();
            long l = level.getGameTime();
            float period = 100.0f;
            float h = (float)Math.floorMod((long)pos.getX() * 7L + (long)pos.getY() * 9L + (long)pos.getZ() * 13L + l, (long)period) / period;
            level.addParticle((ParticleOptions)SleepTight.DREAM_PARTICLE.get(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.625f), (double)((float)pos.getZ() + 0.5f), (double)h, 0.0, 1.0);
        }
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.isRemoved() && !this.level().isClientSide) {
            NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)this, (CustomPacketPayload)ClientBoundParticleMessage.dreamEssence(this.blockPosition()));
        }
        super.remove(reason);
    }

    public static void spawnDeathParticles(Level level, BlockPos pos) {
        if (level.isClientSide()) {
            int i = 0;
            while ((float)i < Mth.randomBetween((RandomSource)level.getRandom(), (float)30.0f, (float)50.0f)) {
                level.addParticle((ParticleOptions)SleepTight.DREAM_PARTICLE.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.3125, (double)pos.getZ() + 0.5, 0.0, 0.0, 2.0);
                ++i;
            }
        }
    }

    public void baseTick() {
    }

    public boolean hurt(DamageSource source, float amount) {
        return source.getEntity() instanceof Phantom;
    }

    public boolean mayInteract(Level level, BlockPos pos) {
        return false;
    }

    public void move(MoverType type, Vec3 pos) {
    }

    public void setHealth(float health) {
    }

    public Iterable<ItemStack> getArmorSlots() {
        return List.of();
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public void setDeltaMovement(Vec3 motionIn) {
    }

    public void knockback(double strength, double x, double z) {
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected boolean isImmobile() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    protected void markHurt() {
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return null;
    }

    public static AttributeSupplier.Builder makeAttributes() {
        return Mob.createMobAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.FLYING_SPEED, 0.0);
    }
}

