/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.network;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.common.entities.DreamerEssenceTargetEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ClientBoundParticleMessage
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundParticleMessage> TYPE = Message.makeType((ResourceLocation)SleepTight.res("particle"), ClientBoundParticleMessage::new);
    private final BlockPos pos;
    private final int data;

    public ClientBoundParticleMessage(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.data = buf.readInt();
    }

    private ClientBoundParticleMessage(BlockPos pos, int data) {
        this.pos = pos;
        this.data = data;
    }

    public static ClientBoundParticleMessage bedbugInfest(BlockPos pos, Direction direction) {
        return new ClientBoundParticleMessage(pos, direction.get2DDataValue());
    }

    public static ClientBoundParticleMessage bedbugDoor(BlockPos pos) {
        return new ClientBoundParticleMessage(pos, 5);
    }

    public static ClientBoundParticleMessage dreamEssence(BlockPos pos) {
        return new ClientBoundParticleMessage(pos, 4);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.data);
    }

    public void handle(Message.Context context) {
        Level level = SleepTightClient.getPlayer().level();
        if (this.data < 4) {
            this.spawnParticleOnBed(this.pos, level);
            this.spawnParticleOnBed(this.pos.relative(Direction.from2DDataValue((int)this.data)), level);
        } else if (this.data == 4) {
            DreamerEssenceTargetEntity.spawnDeathParticles(level, this.pos);
        } else {
            level.addDestroyBlockEffect(this.pos, level.getBlockState(this.pos));
        }
    }

    private void spawnParticleOnBed(BlockPos pos, Level level) {
        for (int i = 0; i < 6 + level.random.nextInt(10); ++i) {
            float x = (float)pos.getX() + level.random.nextFloat();
            float z = (float)pos.getZ() + level.random.nextFloat();
            float y = (float)pos.getY() + 0.5625f;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        }
    }

    public CustomPacketPayload.Type<?> type() {
        return TYPE.type();
    }
}

