/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class BedData {
    public static final ResourceLocation ID = SleepTight.res("bed_data");
    public static final Codec<BedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(BedData::getId), (App)Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)Codec.BYTE).optionalFieldOf("bed_level").forGetter(d -> d.bedLevel.isEmpty() ? Optional.empty() : Optional.of(d.bedLevel)), (App)CompoundTag.CODEC.optionalFieldOf("bed_bug").forGetter(d -> Optional.ofNullable(d.bedBug))).apply((Applicative)instance, BedData::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, Map<UUID, Byte>> BED_LEVEL_STREAM_CODEC = ByteBufCodecs.map(i -> new HashMap(), (StreamCodec)UUIDUtil.STREAM_CODEC, (StreamCodec)ByteBufCodecs.BYTE);
    public static final StreamCodec<RegistryFriendlyByteBuf, BedData> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, BedData::getId, BED_LEVEL_STREAM_CODEC, BedData::getBedLevels, (StreamCodec)ByteBufCodecs.BOOL, d -> d.bedBug != null, BedData::ofClient);
    protected UUID id;
    protected Map<UUID, Byte> bedLevel;
    @Nullable
    protected CompoundTag bedBug;

    private BedData(UUID id, Optional<Map<UUID, Byte>> homeBedTo, Optional<CompoundTag> bedBug) {
        this.id = id;
        this.bedLevel = new HashMap<UUID, Byte>(homeBedTo.orElse(Collections.emptyMap()));
        this.bedBug = bedBug.orElse(null);
    }

    public static BedData initializeWithRandomId() {
        return new BedData(UUID.randomUUID(), Optional.empty(), Optional.empty());
    }

    private static BedData ofClient(UUID uuid, Map<UUID, Byte> levels, Boolean aBoolean) {
        return new BedData(uuid, Optional.of(levels), aBoolean != false ? Optional.of(new CompoundTag()) : Optional.empty());
    }

    public void incrementBedLevel(Player player) {
        UUID playerId = player.getUUID();
        byte value = (byte)Math.min(CommonConfigs.HOME_BED_MAX_LEVEL.get(), this.bedLevel.getOrDefault(playerId, (byte)0) + 1);
        this.bedLevel.put(playerId, value);
    }

    public byte getBedLevel(Player player) {
        return this.bedLevel.getOrDefault(player.getUUID(), (byte)0);
    }

    public Map<UUID, Byte> getBedLevels() {
        return Collections.unmodifiableMap(this.bedLevel);
    }

    public UUID getId() {
        return this.id;
    }

    public boolean isInfested() {
        return this.bedBug != null;
    }

    public void setBedBug(@Nullable CompoundTag entityTag) {
        this.bedBug = entityTag;
    }

    public CompoundTag getBedBug() {
        return this.bedBug;
    }

    public String toString() {
        return "BedData[id=" + String.valueOf(this.id) + ", bedBug=" + (this.bedBug != null ? "present" : "null") + ", bedLevel=" + String.valueOf(this.bedLevel) + "]";
    }
}

