/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.client.ClientEvents;
import net.mehvahdjukaar.sleep_tight.common.InvigoratedEffect;
import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.blocks.NightBagBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.items.BedbugEggsItem;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundNightmarePacket;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundParticleMessage;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundSyncPlayerSleepCapMessage;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.mehvahdjukaar.sleep_tight.core.SleepEffectsHelper;
import net.mehvahdjukaar.sleep_tight.core.WakeReason;
import net.mehvahdjukaar.sleep_tight.core.WakeUpEncounterHelper;
import net.mehvahdjukaar.sleep_tight.integration.HandcraftedCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModEvents {
    public static long getWakeUpTimeWhenSlept(ServerLevel level, long newTimeDayTime) {
        WakeReason wakeReason = WakeReason.SLEPT_SUCCESSFULLY;
        List<ServerPlayer> sleepingPlayers = level.players().stream().filter(Player::isSleepingLongEnough).toList();
        ISleepTightBed firstValid = (ISleepTightBed)Blocks.RED_BED;
        for (Player player : sleepingPlayers) {
            ISleepTightBed st;
            Block block = level.getBlockState((BlockPos)player.getSleepingPos().get()).getBlock();
            if (!(block instanceof ISleepTightBed)) continue;
            firstValid = st = (ISleepTightBed)block;
            break;
        }
        HashSet<ServerPlayer> encounterSpawnedFor = new HashSet<ServerPlayer>();
        for (ServerPlayer player : sleepingPlayers) {
            if (!player.gameMode.isSurvival() || !WakeUpEncounterHelper.tryPerformEncounter(player, level, (BlockPos)player.getSleepingPos().get())) continue;
            wakeReason = WakeReason.ENCOUNTER;
            encounterSpawnedFor.add(player);
        }
        if (wakeReason == WakeReason.SLEPT_SUCCESSFULLY) {
            double nightmareChance;
            double d = 0.0;
            int players = 0;
            for (ServerPlayer player : sleepingPlayers) {
                ++players;
                PlayerSleepData c = STPlatStuff.getPlayerSleepData((Player)player);
                d += c.getNightmareChance((Player)player, (BlockPos)player.getSleepingPos().get());
            }
            double d2 = nightmareChance = players == 0 ? 0.0 : d / (double)players;
            if ((double)level.random.nextFloat() < nightmareChance) {
                wakeReason = WakeReason.NIGHTMARE;
            }
        }
        long l = level.getDayTime();
        long newWakeTime = firstValid.st_modifyWakeUpTime(wakeReason, newTimeDayTime, l);
        long dayTimeDelta = (newWakeTime + 24000L - l) % 24000L;
        for (ServerPlayer player : sleepingPlayers) {
            switch (wakeReason) {
                case SLEPT_SUCCESSFULLY: {
                    ModEvents.onPlayerSleepFinished(player, dayTimeDelta, newWakeTime);
                    break;
                }
                case ENCOUNTER: {
                    ModEvents.onEncounter(player, encounterSpawnedFor.contains(player), newWakeTime);
                    break;
                }
                case NIGHTMARE: {
                    ModEvents.onNightmare(player, newWakeTime);
                }
            }
        }
        return newWakeTime;
    }

    public static boolean canSetSpawn(Player player, @Nullable BlockPos pos) {
        if (pos != null) {
            Level level = player.level();
            Block block = level.getBlockState(pos).getBlock();
            if (block instanceof BedBlock) {
                PlayerSleepData pd;
                if (CommonConfigs.ONLY_RESPAWN_IN_HOME_BED.get().booleanValue() && (pd = STPlatStuff.getPlayerSleepData(player)).isBedLastSleptInto(STPlatStuff.getBedData(level, pos))) {
                    return false;
                }
                if (!BedBlock.canSetSpawn((Level)level) && !CommonConfigs.EXPLOSION_BEHAVIOR.get().canRespawn()) {
                    return false;
                }
            }
            if (block instanceof NightBagBlock) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static InteractionResult onRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult ret;
        if (player.isSpectator()) {
            return null;
        }
        BlockPos pos = hitResult.getBlockPos();
        BlockState state = level.getBlockState(pos);
        Block b = state.getBlock();
        BedData data = STPlatStuff.getBedData(level, pos);
        if (data == null) {
            return null;
        }
        if (data.isInfested()) {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.getItem() instanceof LingeringPotionItem || stack.getItem() instanceof SplashPotionItem) {
                return InteractionResult.PASS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"message.sleep_tight.bedbug"), true);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        Direction dir = (Direction)state.getValue((Property)BedBlock.FACING);
        if (SleepTight.HANDCRAFTED && (ret = HandcraftedCompat.placeSheet(state, pos, player, hand, hitResult).result()) != InteractionResult.PASS) {
            return ret;
        }
        if (!(state = level.getBlockState(pos = ModEvents.getBedHead(state, pos))).is(b)) {
            return InteractionResult.PASS;
        }
        ItemStack itemInHand = player.getItemInHand(hand);
        Item item = itemInHand.getItem();
        if (item instanceof BedbugEggsItem) {
            BedbugEggsItem bb = (BedbugEggsItem)item;
            return bb.useOnBed(player, hand, itemInHand, state, pos, hitResult);
        }
        if (BedBlock.canSetSpawn((Level)level) && !player.isSecondaryUseActive() && !ModEvents.bedBlocked(level, pos, dir)) {
            boolean occupied = (Boolean)state.getValue((Property)BedBlock.OCCUPIED);
            if (occupied) {
                List list = level.getEntitiesOfClass(BedEntity.class, new AABB(pos));
                if (!list.isEmpty()) {
                    BedEntity bedEntity = (BedEntity)((Object)list.get(0));
                    if (!bedEntity.isDoubleBed()) {
                        return InteractionResult.PASS;
                    }
                    bedEntity.clearDoubleBed();
                    pos = bedEntity.getDoubleBedPos();
                    state = (BlockState)state.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(false));
                    level.setBlockAndUpdate(pos, state);
                    occupied = false;
                } else {
                    BlockPos doublePos = BedEntity.getInverseDoubleBedPos(pos, state);
                    list = level.getEntitiesOfClass(BedEntity.class, new AABB(doublePos));
                    if (!list.isEmpty()) {
                        BedEntity bedEntity = (BedEntity)((Object)list.get(0));
                        if (!bedEntity.isDoubleBed()) {
                            return InteractionResult.PASS;
                        }
                        bedEntity.clearDoubleBed();
                        state = (BlockState)state.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(false));
                        level.setBlockAndUpdate(pos, state);
                        occupied = false;
                    }
                }
            }
            if (!occupied) {
                boolean extraConditions;
                boolean bl = extraConditions = CommonConfigs.LAY_WHEN_ON_COOLDOWN.get() != false || ModEvents.checkExtraSleepConditions(player, pos);
                if (!extraConditions) {
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                BedEntity.layDown(state, pos, player);
                return InteractionResult.SUCCESS;
            }
        }
        return null;
    }

    private static boolean bedBlocked(Level level, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.above();
        return !ModEvents.freeAt(level, blockPos) || !ModEvents.freeAt(level, blockPos.relative(direction.getOpposite()));
    }

    protected static boolean freeAt(Level level, BlockPos pos) {
        return !level.getBlockState(pos).isSuffocating((BlockGetter)level, pos);
    }

    public static Vec3 getSleepingPosition(Entity entity, BlockState state, BlockPos pos) {
        Block block;
        if (entity.level().isClientSide) {
            ClientEvents.onSleepStarted(entity, state, pos);
        }
        if ((block = state.getBlock()) instanceof IModBed) {
            IModBed iModBed = (IModBed)block;
            return iModBed.getSleepingPosition(state, pos);
        }
        if (state.is(BlockTags.BEDS)) {
            Player player;
            PlayerSleepData data;
            Vec3 c = Vec3.ZERO;
            if (CommonConfigs.FIX_BED_POSITION.get().booleanValue()) {
                c = c.add((double)pos.getX() + 0.5, (double)((float)pos.getY() + 0.5625f), (double)pos.getZ() + 0.5);
            }
            if (entity instanceof Player && (data = STPlatStuff.getPlayerSleepData(player = (Player)entity)).usingDoubleBed()) {
                c = BedEntity.getDoubleBedOffset((Direction)state.getValue((Property)BedBlock.FACING), c);
            }
            if (c != Vec3.ZERO) {
                return c;
            }
        }
        return null;
    }

    private static void onEncounter(ServerPlayer player, boolean mobSpawned, long wakeTime) {
        if (mobSpawned) {
            PlayerSleepData c = STPlatStuff.getPlayerSleepData((Player)player);
            c.setInsomniaCooldown(wakeTime, CommonConfigs.ENCOUNTER_INSOMNIA_DURATION.get().intValue());
            c.setLasWokenUpTime(wakeTime);
            c.resetConsecutiveNightSleptCounter();
            c.syncToClient(player);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.sleep_tight.encounter"), true);
        }
    }

    private static void onNightmare(ServerPlayer player, long wakeTime) {
        PlayerSleepData c = STPlatStuff.getPlayerSleepData((Player)player);
        c.setInsomniaCooldown(wakeTime, CommonConfigs.NIGHTMARE_INSOMNIA_DURATION.get().intValue());
        c.setLasWokenUpTime(wakeTime);
        c.resetConsecutiveNightSleptCounter();
        c.syncToClient(player);
        player.displayClientMessage((Component)Component.translatable((String)"message.sleep_tight.nightmare"), true);
        player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 60, 0, false, false, false, null));
        NetworkHelper.sendToClientPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientBoundNightmarePacket());
    }

    public static void onPlayerSleepFinished(ServerPlayer player, long dayTimeDelta, long wakeUpTime) {
        Optional p = player.getSleepingPos();
        if (p.isPresent()) {
            BedData data;
            BlockPos pos = (BlockPos)p.get();
            PlayerSleepData playerCap = STPlatStuff.getPlayerSleepData((Player)player);
            Level level = player.level();
            BlockState state = level.getBlockState(pos);
            ISleepTightBed bed = (ISleepTightBed)Blocks.RED_BED;
            Block block = state.getBlock();
            if (block instanceof ISleepTightBed) {
                ISleepTightBed b;
                bed = b = (ISleepTightBed)block;
            }
            if ((data = STPlatStuff.getBedData(level, pos)) != null) {
                playerCap.increaseNightSleptInThisBed(data, (Player)player);
            }
            playerCap.increaseConsecutiveNightSleptCounter(wakeUpTime);
            playerCap.setLasWokenUpTime(wakeUpTime);
            if (bed.st_canSpawnBedbugs()) {
                WakeUpEncounterHelper.trySpawningBedbug(pos, player, data);
            }
            SleepEffectsHelper.applyEffectsOnWakeUp(playerCap, player, dayTimeDelta, pos, bed, state, data);
            playerCap.setInsomniaCooldown(wakeUpTime, bed.st_getCooldown());
            playerCap.syncToClient(player);
        }
    }

    public static void onWokenUp(Player player, boolean hasWokenUpImmediately) {
        Optional p = player.getSleepingPos();
        if (p.isPresent()) {
            BlockPos pos = (BlockPos)p.get();
            Level level = player.level();
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            if (block instanceof IModBed) {
                IModBed bed = (IModBed)block;
                bed.onLeftBed(state, pos, player);
            } else if (state.is(BlockTags.BEDS) && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerSleepData data = STPlatStuff.getPlayerSleepData(player);
                if (data.usingDoubleBed()) {
                    BlockPos doublePos = BedEntity.getDoubleBedPos(pos, state);
                    BlockState doubleState = level.getBlockState(doublePos);
                    if (doubleState.is(BlockTags.BEDS) && (doubleState = (BlockState)doubleState.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(false))) == state) {
                        level.setBlockAndUpdate(doublePos, doubleState);
                    }
                    data.setDoubleBed(false);
                    data.syncToClient(serverPlayer);
                }
            }
        }
    }

    public static boolean shouldCancelSetSpawn(Player entity, BlockPos newSpawn) {
        Block block = entity.level().getBlockState(newSpawn).getBlock();
        if (block instanceof IModBed) {
            IModBed bed = (IModBed)block;
            return !bed.canSetSpawn();
        }
        return false;
    }

    public static void onPlayerLoggedIn(ServerPlayer player) {
        NetworkHelper.sendToClientPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientBoundSyncPlayerSleepCapMessage((Player)player));
    }

    public static boolean checkExtraSleepConditions(Player player, @Nullable BlockPos bedPos) {
        Level level = player.level();
        BedData bedData = STPlatStuff.getBedData(level, bedPos);
        if (bedData != null && bedData.isInfested()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.sleep_tight.bedbug"), true);
            return false;
        }
        if (STPlatStuff.getPlayerSleepData(player).isOnSleepCooldown(player)) {
            if (!player.level().isClientSide) {
                String s = ModEvents.isDayTime(player.level()) ? "message.sleep_tight.insomnia.day" : "message.sleep_tight.insomnia.night";
                player.displayClientMessage((Component)Component.translatable((String)s), true);
            }
            return false;
        }
        return SleepEffectsHelper.checkExtraRequirements(player, bedPos);
    }

    public static InteractionResult onCheckSleepTime(Level level, BlockPos pos) {
        Block block = level.getBlockState(pos).getBlock();
        if (block instanceof IModBed) {
            IModBed bed = (IModBed)block;
            return bed.canSleepAtTime(level);
        }
        return InteractionResult.PASS;
    }

    public static void onEntityKilled(LivingEntity entity, Entity killer) {
        Level level;
        if (!entity.isRemoved() && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (killer instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)killer;
                if (killer.killedEntity(serverLevel, entity)) {
                    InvigoratedEffect.onLivingDeath(serverLevel, entity, le);
                }
            }
        }
    }

    public static boolean isDayTime(Level level) {
        int dayDuration = 24000;
        long dayTime = level.getDayTime() % (long)dayDuration;
        return dayTime > 100L && dayTime < (long)(dayDuration / 2 - 100);
    }

    public static void onPlayerRespawned(ServerPlayer newPlayer) {
        BlockPos pos;
        if (CommonConfigs.RESPAWN_LAYING.get().booleanValue() && (pos = newPlayer.getRespawnPosition()) != null) {
            BlockState state = newPlayer.level().getBlockState(pos);
            BedData bedData = STPlatStuff.getBedData(newPlayer.level(), pos);
            if (bedData != null) {
                BedEntity.layDown(state, pos, (Player)newPlayer);
            }
        }
    }

    public static boolean shouldCancelRespawnHere(Player player, DimensionTransition transition) {
        BedData bedData;
        return CommonConfigs.ONLY_RESPAWN_IN_HOME_BED.get() != false && (bedData = STPlatStuff.getBedData(player.level(), BlockPos.containing((Position)transition.pos()))) != null && !STPlatStuff.getPlayerSleepData(player).isBedLastSleptInto(bedData);
    }

    public static void onProjectileHitBed(Projectile projectile, Level level, BlockState state, BlockHitResult hit) {
        if (projectile instanceof ThrownPotion) {
            PotionContents p;
            ThrownPotion tp = (ThrownPotion)projectile;
            BlockPos myPos = hit.getBlockPos();
            BlockPos pos = ModEvents.getBedHead(state, myPos);
            BedData data = STPlatStuff.getBedData(level, pos);
            if (data != null && data.isInfested() && (p = (PotionContents)tp.getItem().get(DataComponents.POTION_CONTENTS)) != null && StreamSupport.stream(p.getAllEffects().spliterator(), false).anyMatch(e -> e.getEffect() == MobEffects.HARM)) {
                level.playSound(null, pos, SoundEvents.SILVERFISH_DEATH, SoundSource.BLOCKS, 1.0f, 1.3f);
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    NetworkHelper.sendToAllClientPlayersInRange((ServerLevel)sl, (BlockPos)pos, (double)32.0, (CustomPacketPayload)ClientBoundParticleMessage.bedbugInfest(pos, ((Direction)state.getValue((Property)BedBlock.FACING)).getOpposite()));
                }
                data.setBedBug(null);
                BlockEntity tile = level.getBlockEntity(pos);
                if (tile != null) {
                    level.sendBlockUpdated(pos, state, state, 3);
                    tile.setChanged();
                }
            }
        }
    }

    public static void spawnAfterBreakBed(BlockState state, ServerLevel level, BlockPos pos, @Nullable BlockEntity be) {
        if (level.isClientSide) {
            return;
        }
        BedData data = STPlatStuff.getBedData((Level)level, pos, be);
        if (data != null && data.isInfested() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            CompoundTag tag = data.getBedBug();
            Optional opt = EntityType.create((CompoundTag)tag, (Level)level);
            if (opt.isEmpty()) {
                return;
            }
            Entity entity = (Entity)opt.get();
            pos = ModEvents.bedBedFeet(state, pos);
            entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            level.addFreshEntity(entity);
            if (entity instanceof Mob) {
                Mob le = (Mob)entity;
                le.spawnAnim();
            }
        }
    }

    public static void animateTickBed(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BedData data;
        if ((double)random.nextFloat() < 0.3 && (data = STPlatStuff.getBedData(level, pos)) != null && data.isInfested()) {
            float x = (float)pos.getX() + level.random.nextFloat();
            float z = (float)pos.getZ() + level.random.nextFloat();
            double y = state.getCollisionShape((BlockGetter)level, pos).max(Direction.Axis.Y) + (double)pos.getY();
            level.addParticle((ParticleOptions)SleepTight.BEDBUG_PARTICLE.get(), (double)x, y + 0.01, (double)z, 0.0, 0.0, 0.0);
        }
    }

    public static BlockPos getBedHead(BlockState bed, BlockPos pos) {
        if (!bed.hasProperty((Property)BedBlock.PART)) {
            return pos;
        }
        BedPart part = (BedPart)bed.getValue((Property)BedBlock.PART);
        if (part == BedPart.HEAD) {
            return pos;
        }
        Direction dir = (Direction)bed.getValue((Property)BedBlock.FACING);
        return pos.relative(dir);
    }

    public static BlockPos bedBedFeet(BlockState bed, BlockPos pos) {
        if (!bed.hasProperty((Property)BedBlock.PART)) {
            return pos;
        }
        BedPart part = (BedPart)bed.getValue((Property)BedBlock.PART);
        if (part == BedPart.FOOT) {
            return pos;
        }
        Direction dir = (Direction)bed.getValue((Property)BedBlock.FACING);
        return pos.relative(dir.getOpposite());
    }

    public static boolean shouldHaveBedData(BlockEntity blockEntity) {
        BedBlockEntity be;
        BlockState state = blockEntity.getBlockState();
        if (state.is(SleepTight.LAYING_BED_BLACKLIST)) {
            return false;
        }
        return state.getBlock() instanceof BedBlock && state.getValue((Property)BedBlock.PART) == BedPart.HEAD || blockEntity instanceof BedBlockEntity && (be = (BedBlockEntity)blockEntity).getBlockState().hasProperty((Property)BedBlock.PART) && be.getBlockState().getValue((Property)BedBlock.PART) == BedPart.HEAD;
    }
}

