/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.ArrayList;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.configs.EffectData;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.mehvahdjukaar.sleep_tight.integration.HeartstoneCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class SleepEffectsHelper {
    public static void applyEffectsOnWakeUp(PlayerSleepData playerCap, ServerPlayer player, long dayTimeDelta, BlockPos pos, ISleepTightBed bed, BlockState state, @Nullable BedData data) {
        if (data != null) {
            SleepEffectsHelper.applyVanillaBedBonuses(player, dayTimeDelta, data, playerCap);
            SleepEffectsHelper.applyHeartstoneBonuses(player, pos, state, data, playerCap);
        }
        if (!player.isCreative()) {
            if (bed.st_hasPenalties()) {
                SleepEffectsHelper.applySleepPenalties(player, dayTimeDelta);
            }
            if (bed.st_hasRequirements()) {
                SleepEffectsHelper.paySleepRequirements(player);
            }
        }
    }

    private static void applySleepPenalties(ServerPlayer player, long dayTimeDelta) {
        double hunger = CommonConfigs.CONSUMED_HUNGER.get();
        if (hunger == 0.0) {
            return;
        }
        CommonConfigs.HungerMode mode = CommonConfigs.CONSUME_HUNGER_MODE.get();
        if (mode == CommonConfigs.HungerMode.DIFFICULTY_BASED || mode == CommonConfigs.HungerMode.TIME_DIFFICULTY_BASED) {
            int diff = player.level().getDifficulty().getId();
            if (diff == 0) {
                return;
            }
            hunger *= 1.0 + (double)(diff - 1) * 0.25;
        }
        if (mode == CommonConfigs.HungerMode.TIME_BASED || mode == CommonConfigs.HungerMode.TIME_DIFFICULTY_BASED) {
            hunger = hunger / 11000.0 * (double)dayTimeDelta;
        }
        int level = player.getFoodData().getFoodLevel();
        level = (int)Mth.clamp((double)((double)level - hunger), (double)0.0, (double)20.0);
        player.getFoodData().setFoodLevel(level);
    }

    private static void applyVanillaBedBonuses(ServerPlayer player, long dayTimeDelta, BedData bedData, PlayerSleepData playerSleepData) {
        CommonConfigs.EffectIntensity potionClearing;
        CommonConfigs.BedStatus status = CommonConfigs.BED_BENEFITS.get();
        if (status == CommonConfigs.BedStatus.NONE) {
            return;
        }
        if (status == CommonConfigs.BedStatus.HOME_BED && !playerSleepData.isBedLastSleptInto(bedData)) {
            return;
        }
        CommonConfigs.EffectIntensity healing = CommonConfigs.HEALING.get();
        if (healing != CommonConfigs.EffectIntensity.NONE) {
            float maxHealth;
            float heal = maxHealth = player.getMaxHealth();
            if (healing == CommonConfigs.EffectIntensity.TIME_BASED) {
                heal = maxHealth / 12000.0f * (float)dayTimeDelta;
            }
            player.heal(heal);
        }
        if ((potionClearing = CommonConfigs.EFFECT_CLEARING.get()) != CommonConfigs.EffectIntensity.NONE) {
            CommonConfigs.PotionClearing type = CommonConfigs.EFFECT_CLEARING_TYPE.get();
            boolean timeBased = potionClearing == CommonConfigs.EffectIntensity.TIME_BASED;
            ArrayList<MobEffectInstance> toEditOrRemove = new ArrayList<MobEffectInstance>();
            block6: for (MobEffectInstance e : player.getActiveEffects()) {
                switch (type) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case ALL: {
                        break;
                    }
                    case HARMFUL: {
                        if (((MobEffect)e.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL) continue block6;
                        break;
                    }
                    case BENEFICIAL: {
                        if (((MobEffect)e.getEffect().value()).getCategory() != MobEffectCategory.BENEFICIAL) continue block6;
                        break;
                    }
                    case NEUTRAL: {
                        if (((MobEffect)e.getEffect().value()).getCategory() != MobEffectCategory.NEUTRAL) continue block6;
                    }
                }
                toEditOrRemove.add(e);
            }
            for (MobEffectInstance e : toEditOrRemove) {
                long remainingTime;
                player.removeEffect(e.getEffect());
                if (!timeBased || (remainingTime = (long)e.getDuration() - dayTimeDelta) <= 0L) continue;
                CompoundTag tag = (CompoundTag)e.save();
                tag.putInt("Duration", (int)remainingTime);
                MobEffectInstance load = MobEffectInstance.load((CompoundTag)tag);
                if (load == null) continue;
                player.addEffect(load);
            }
        }
        if (playerSleepData.isBedFamiliarityMaxed(bedData)) {
            for (EffectData e : CommonConfigs.WAKE_UP_EFFECTS.get()) {
                player.addEffect(e.createInstance(bedData.getBedLevel((Player)player) - 1));
            }
        }
    }

    private static void applyHeartstoneBonuses(ServerPlayer player, BlockPos pos, BlockState state, BedData bedData, PlayerSleepData playerSleepData) {
        BlockPos otherPos = SleepEffectsHelper.getPartnerPos((Player)player, state, pos);
        if (otherPos != null && playerSleepData.isBedFamiliarityMaxed(bedData)) {
            for (EffectData e : CommonConfigs.HEARTSTONE_EFFECT.get()) {
                player.addEffect(e.createInstance(bedData.getBedLevel((Player)player) - 1));
            }
        }
    }

    private static void paySleepRequirements(ServerPlayer serverPlayer) {
        serverPlayer.giveExperiencePoints(-CommonConfigs.XP_COST.get().intValue());
    }

    public static boolean checkExtraRequirements(Player player, @Nullable BlockPos bedPos) {
        if (bedPos != null && !player.getAbilities().instabuild) {
            Level level = player.level();
            BlockEntity tile = level.getBlockEntity(bedPos);
            if (tile == null && !CommonConfigs.REQUIREMENT_NIGHT_BAG.get().booleanValue()) {
                return true;
            }
            if (tile instanceof HammockTile && !CommonConfigs.REQUIREMENT_HAMMOCK.get().booleanValue()) {
                return true;
            }
            if (!CommonConfigs.REQUIREMENT_BED.get().booleanValue()) {
                return true;
            }
            int xp = CommonConfigs.XP_COST.get();
            if (xp != 0 && player.totalExperience < xp) {
                if (level.isClientSide) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.sleep_tight.xp"), true);
                }
                return false;
            }
            if (CommonConfigs.NEED_FULL_HUNGER.get().booleanValue() && player.getFoodData().needsFood()) {
                if (level.isClientSide) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.sleep_tight.hunger"), true);
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static BlockPos getPartnerPos(Player player, BlockState state, BlockPos pos) {
        CommonConfigs.HeartstoneMode mode = CommonConfigs.HEARTSTONE_MODE.get();
        Level level = player.level();
        if (mode != CommonConfigs.HeartstoneMode.OFF && state.getBlock() instanceof BedBlock) {
            BlockPos otherPos = BedEntity.getDoubleBedPos(pos, state);
            boolean x = SleepEffectsHelper.hasPartnerAt(player, mode, level, otherPos);
            if (!x) {
                otherPos = BedEntity.getInverseDoubleBedPos(pos, state);
                x = SleepEffectsHelper.hasPartnerAt(player, mode, level, otherPos);
            }
            if (x) {
                return otherPos;
            }
        }
        return null;
    }

    private static boolean hasPartnerAt(Player player, CommonConfigs.HeartstoneMode mode, Level level, BlockPos otherPos) {
        BlockState leftState = level.getBlockState(otherPos);
        if (leftState.getBlock() instanceof BedBlock && ((Boolean)leftState.getValue((Property)BedBlock.OCCUPIED)).booleanValue()) {
            AABB bb = new AABB(otherPos);
            for (LivingEntity entity : level.getEntitiesOfClass(LivingEntity.class, bb, v -> v.getSleepingPos().map(p -> p.equals((Object)otherPos)).orElse(false))) {
                if (mode.allowVillagers && entity instanceof Villager) {
                    return true;
                }
                if (!(entity instanceof Player)) continue;
                Player p = (Player)entity;
                if (mode.needsHeartstone && (!SleepTight.HS || !HeartstoneCompat.isFren(player, p))) continue;
                return true;
            }
        }
        return false;
    }
}

