/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.items.NightBagItem;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4061;
import net.minecraft.class_423;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_9080;
import net.minecraft.class_9779;

public class SleepGuiOverlay
extends class_329
implements class_9080.class_9081 {
    private static final class_2960 BACKGROUND = class_2960.method_60656((String)"boss_bar/white_background");
    private static final class_2960 PROGRESS = class_2960.method_60656((String)"boss_bar/white_progress");
    private static final class_2960 OVERLAY_BACKGROUND = class_2960.method_60656((String)"boss_bar/notched_6_background");
    private static final class_2960 OVERLAY_PROGRESS = class_2960.method_60656((String)"boss_bar/notched_6_progress");

    public SleepGuiOverlay(class_310 minecraft) {
        super(minecraft);
    }

    public void method_1753(class_332 graphics, class_9779 deltaTracker) {
        class_310 mc = class_310.method_1551();
        class_315 options = mc.field_1690;
        BedData bedData = SleepTightClient.getLayingBedData();
        class_746 player = mc.field_1724;
        if (bedData != null) {
            PlayerSleepData playerData = STPlatStuff.getPlayerSleepData((class_1657)player);
            SleepGuiOverlay.renderBar(graphics, bedData, playerData, mc, (class_1657)player, deltaTracker.method_60636());
            return;
        }
        class_239 hit = mc.field_1765;
        boolean cooldown = ClientConfigs.INSOMNIA_COOLDOWN.get();
        boolean timer = ClientConfigs.INSOMNIA_TIMER.get();
        if (!timer && !cooldown) {
            return;
        }
        this.renderCooldownCrossAir(graphics, options, mc, hit, (class_1657)player, cooldown, timer);
    }

    private void renderCooldownCrossAir(class_332 graphics, class_315 options, class_310 mc, class_239 hit, class_1657 player, boolean cooldown, boolean timer) {
        PlayerSleepData playerData;
        float insomniaPerc;
        class_3965 bh;
        boolean laying;
        if (options.method_31044().method_31034() && (mc.field_1761.method_2920() != class_1934.field_9219 || this.method_17534(hit)) && ((laying = player.method_5854() instanceof BedEntity) || cooldown && (hit instanceof class_3965 && mc.field_1687.method_8320((bh = (class_3965)hit).method_17777()).method_26204() instanceof ISleepTightBed || player.method_6047().method_7909() instanceof NightBagItem)) && (insomniaPerc = 1.0f - (playerData = STPlatStuff.getPlayerSleepData(player)).getInsomniaCooldownPercentage(player)) < 1.0f) {
            if (laying && timer) {
                graphics.method_25303(mc.field_1772, "" + playerData.getInsomniaCooldown(player) / 20L, 2, 2, 0xE0E0E0);
            }
            if (cooldown) {
                this.setupOverlayRenderState(graphics, true, false, SleepTightClient.ICONS);
                graphics.method_51448().method_22903();
                RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
                int py = graphics.method_51443() / 2 - 7 + 16;
                int px = graphics.method_51421() / 2 - 6;
                if (mc.field_1690.method_42565().method_41753() == class_4061.field_18152 && player.method_7261(0.0f) != 1.0f) {
                    py += 8;
                }
                int l = (int)(insomniaPerc * 11.0f);
                graphics.method_25290(SleepTightClient.ICONS, px, py, 3.0f, 18.0f, 11, 5, 48, 48);
                graphics.method_25290(SleepTightClient.ICONS, px, py, 19.0f, 18.0f, l, 5, 48, 48);
                graphics.method_51448().method_22909();
                RenderSystem.defaultBlendFunc();
            }
        }
    }

    protected void setupOverlayRenderState(class_332 graphics, boolean blend, boolean depthTest, class_2960 texture) {
    }

    public static void renderBedScreenOverlay(class_423 s, class_332 graphics, int mouseX, int mouseY) {
        int dx;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        class_2338 sleepingPos = player.method_18398().orElse(null);
        if (sleepingPos == null) {
            return;
        }
        PlayerSleepData playerData = STPlatStuff.getPlayerSleepData((class_1657)player);
        BedData bedData = STPlatStuff.getBedData(player.method_37908(), sleepingPos);
        if (bedData == null) {
            return;
        }
        boolean hasDreamerEssence = DreamEssenceBlock.isInRange(sleepingPos, player.method_37908());
        boolean isMaxFamiliar = playerData.isBedFamiliarityMaxed(bedData);
        if (ClientConfigs.SHOW_TIME.get().booleanValue()) {
            graphics.method_27535(mc.field_1772, SleepGuiOverlay.getCurrentTime(player.method_37908()), 2, 2, 0xE0E0E0);
        }
        int y = s.field_22790 - 39;
        int iconSize = 18;
        int bx = s.field_22789 / 2 - 120;
        int bh = isMaxFamiliar ? 0 : 28;
        graphics.method_25290(SleepTightClient.ICONS, bx, y, 0.0f, (float)bh, iconSize, iconSize, 48, 48);
        if (hasDreamerEssence) {
            int x = s.field_22789 / 2 + 120 - iconSize;
            graphics.method_25290(SleepTightClient.ICONS, x, y, (float)iconSize, 0.0f, iconSize, iconSize, 48, 48);
        }
        if (MthUtils.isWithinRectangle((int)bx, (int)y, (int)iconSize, (int)iconSize, (int)mouseX, (int)mouseY)) {
            double nightmare = playerData.getNightmareChance((class_1657)player, sleepingPos);
            byte bedLevel = bedData.getBedLevel((class_1657)player);
            class_5250 title = isMaxFamiliar ? class_2561.method_43471((String)"gui.sleep_tight.home_bed") : class_2561.method_43471((String)"gui.sleep_tight.bed");
            ArrayList lines = new ArrayList(mc.field_1772.method_1728((class_5348)title, 200));
            if (!isMaxFamiliar) {
                String percent = String.format("%.1f", Float.valueOf(playerData.getBedFamiliarity(bedData) * 100.0f)) + "%";
                lines.addAll(mc.field_1772.method_1728((class_5348)class_2561.method_43469((String)"gui.sleep_tight.familiarity", (Object[])new Object[]{percent}), 200));
            }
            if (PlatHelper.isDev()) {
                lines.addAll(mc.field_1772.method_1728((class_5348)class_2561.method_43470((String)("LastId Bits: " + String.valueOf(bedData.getId()))), 400));
            }
            lines.addAll(mc.field_1772.method_1728((class_5348)class_2561.method_43469((String)"gui.sleep_tight.bed_level", (Object[])new Object[]{(int)bedLevel}), 200));
            lines.addAll(mc.field_1772.method_1728((class_5348)class_2561.method_43469((String)"gui.sleep_tight.nightmare", (Object[])new Object[]{nightmare}), 200));
            graphics.method_51447(mc.field_1772, lines, mouseX, mouseY);
        }
        if (hasDreamerEssence && MthUtils.isWithinRectangle((int)(dx = s.field_22789 / 2 + 120 - iconSize), (int)y, (int)iconSize, (int)iconSize, (int)mouseX, (int)mouseY)) {
            graphics.method_51447(mc.field_1772, mc.field_1772.method_1728((class_5348)class_2561.method_43471((String)"gui.sleep_tight.dreamer_essence"), 200), mouseX, mouseY);
        }
    }

    private static void renderBar(class_332 graphics, BedData bedData, PlayerSleepData playerData, class_310 mc, class_1657 player, float partialTicks) {
        int screenHeight = graphics.method_51443();
        int screenWidth = graphics.method_51421();
        int xpBarLeft = screenWidth / 2 - 91;
        float familiarity = playerData.getBedFamiliarity(bedData);
        boolean hasDreamerEssence = DreamEssenceBlock.isInRange(player.method_24515(), player.method_37908());
        double nightmareChance = playerData.getNightmareChance(player, player.method_24515());
        int barColor = hasDreamerEssence ? 13185173 : 14461959;
        HSVColor color = new RGBColor(barColor).asHSV();
        if (!hasDreamerEssence) {
            float desaturation = (float)(1.0 - nightmareChance * 0.5);
            color = color.withSaturation(color.saturation() * desaturation).withValue(color.value() * desaturation);
        }
        RGBColor rgb = color.asRGB();
        RenderSystem.setShaderColor((float)rgb.red(), (float)rgb.green(), (float)rgb.blue(), (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        int k = (int)(familiarity * 183.0f);
        int xpBarTop = screenHeight - 32 + 3;
        graphics.method_52706(BACKGROUND, xpBarLeft, xpBarTop, 183, 5);
        graphics.method_52706(PROGRESS, xpBarLeft, xpBarTop, k, 5);
        graphics.method_52706(OVERLAY_PROGRESS, xpBarLeft, xpBarTop, 182, 5);
        RenderSystem.disableBlend();
        byte power = bedData.getBedLevel(player);
        boolean bedFamiliarityMaxed = playerData.isBedFamiliarityMaxed(bedData);
        int textCol = hasDreamerEssence ? (bedFamiliarityMaxed ? 12338943 : 6301312) : (bedFamiliarityMaxed ? 57855 : 1598581);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String bedLevelStr = String.valueOf(power);
        int cx = (screenWidth - mc.field_1772.method_1727(bedLevelStr)) / 2;
        int cy = screenHeight - 31 - 4;
        graphics.method_51433(mc.field_1772, bedLevelStr, cx + 1, cy, 0, false);
        graphics.method_51433(mc.field_1772, bedLevelStr, cx - 1, cy, 0, false);
        graphics.method_51433(mc.field_1772, bedLevelStr, cx, cy + 1, 0, false);
        graphics.method_51433(mc.field_1772, bedLevelStr, cx, cy - 1, 0, false);
        graphics.method_51433(mc.field_1772, bedLevelStr, cx, cy, textCol, false);
    }

    private static class_2561 getCurrentTime(class_1937 level) {
        int time = (int)(level.method_8532() + 6000L) % 24000;
        int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
        int h = time / 1000;
        String a = "";
        if (!ClientConfigs.TIME_FORMAT_24H.get().booleanValue()) {
            String string = a = time < 12000 ? " AM" : " PM";
            if ((h %= 12) == 0) {
                h = 12;
            }
        }
        return class_2561.method_43470((String)(h + ":" + (m < 10 ? "0" : "") + m + a));
    }
}

