/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.Optional;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedbugEntity;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6012;
import net.minecraft.class_6880;
import net.minecraft.class_9168;
import org.jetbrains.annotations.Nullable;

public class WakeUpEncounterHelper {
    public static boolean tryPerformEncounter(class_3222 player, class_3218 level, class_2338 bedPos) {
        if (!level.method_8450().method_8355(class_1928.field_19390)) {
            return false;
        }
        class_2338.class_2339 mutable = bedPos.method_25503();
        int monsterSpawnAttempts = CommonConfigs.ENCOUNTER_TRIES.get();
        int maxCount = CommonConfigs.ENCOUNTER_MAX_COUNT.get();
        int max = CommonConfigs.ENCOUNTER_RADIUS.get();
        int min = CommonConfigs.ENCOUNTER_MIN_RADIUS.get();
        int height = CommonConfigs.ENCOUNTER_HEIGHT.get();
        int count = 0;
        class_5138 struct = level.method_27056();
        class_2794 generator = level.method_14178().method_12129();
        class_1311 category = class_1311.field_6302;
        int maxAttempts = (int)((float)monsterSpawnAttempts * level.method_8404(bedPos).method_5457());
        for (int attempt = 0; attempt < maxAttempts && count < maxCount; ++attempt) {
            class_1308 mob;
            Object entity;
            WakeUpEncounterHelper.setRandomPosCyl(bedPos, mutable, level.field_9229, min, max, height);
            Optional<class_1299<?>> spawnData = WakeUpEncounterHelper.getRandomEncounterData(level, struct, generator, category, (class_2338)mutable);
            if (spawnData.isEmpty() || !((entity = WakeUpEncounterHelper.createValidMobToSpawn(player.method_19538(), level, mutable, spawnData.get(), class_3730.field_16459)) instanceof class_1308) || !(mob = (class_1308)entity).method_6057((class_1297)player)) continue;
            WakeUpEncounterHelper.doSpawnMob(level, mob);
            WakeUpEncounterHelper.setupMobToTargetPlayer(player, mob);
            ++count;
        }
        return count != 0;
    }

    private static void doSpawnMob(class_3218 level, class_1308 mob) {
        mob.method_5943((class_5425)level, level.method_8404(mob.method_24515()), class_3730.field_16467, null);
        level.method_30771((class_1297)mob);
    }

    private static void setRandomPosCircle(class_2338 center, class_2338.class_2339 mutable, class_5819 random, int min, int max) {
        int l = random.method_43051(min, max);
        class_243 v = new class_243((double)l, 0.0, 0.0).method_1024(random.method_43057() * (float)Math.PI * 2.0f).method_1037(random.method_43057() * (float)Math.PI);
        mutable.method_10102((double)center.method_10263() + 0.5 + v.field_1352, (double)center.method_10264() + 0.5 + v.field_1351, (double)center.method_10260() + 0.5 + v.field_1350);
    }

    private static void setRandomPosCyl(class_2338 center, class_2338.class_2339 mutable, class_5819 random, int min, int max, int height) {
        int l = random.method_43051(min, max);
        class_243 v = new class_243((double)l, (double)height * (random.method_43058() - 0.5), 0.0).method_1024(random.method_43057() * (float)Math.PI * 2.0f);
        mutable.method_10102((double)center.method_10263() + 0.5 + v.field_1352, (double)center.method_10264() + 0.5 + v.field_1351, (double)center.method_10260() + 0.5 + v.field_1350);
    }

    @Nullable
    private static <T extends class_1297> T createValidMobToSpawn(class_243 centerPos, class_3218 level, class_2338.class_2339 pos, class_1299<T> entityType, class_3730 spawnType) {
        if (level.method_39999((class_2338)pos)) {
            double d = (double)pos.method_10263() + 0.5;
            double e = (double)pos.method_10260() + 0.5;
            double y = pos.method_10264();
            double f = centerPos.method_1028(d, y, e);
            class_9168 type = class_1317.method_6159(entityType);
            if (!(class_1317.method_56558(entityType, (class_4538)level, (class_2338)pos) && class_1317.method_20638(entityType, (class_5425)level, (class_3730)spawnType, (class_2338)pos, (class_5819)level.field_9229) && level.method_18026(entityType.method_58629((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5)))) {
                return null;
            }
            class_1308 mob = class_1948.method_24931((class_3218)level, entityType);
            if (mob == null) {
                return null;
            }
            mob.method_5808(d, (double)pos.method_10264(), e, level.field_9229.method_43057() * 360.0f, 0.0f);
            if (class_1948.method_24932((class_3218)level, (class_1308)mob, (double)f)) {
                return (T)mob;
            }
        }
        return null;
    }

    private static void setupMobToTargetPlayer(class_3222 player, class_1308 mob) {
        mob.method_5951((class_1297)player, 360.0f, 45.0f);
        mob.field_6241 = mob.method_36454();
        mob.field_6259 = mob.method_36454();
        mob.method_5988().method_35111((class_1297)player);
        player.method_18400();
        player.method_14222(class_2183.class_2184.field_9851, (class_1297)mob, class_2183.class_2184.field_9851);
        mob.method_24830(true);
        class_11 path = mob.method_5942().method_6349((class_1297)player, 0);
        if (path != null) {
            mob.method_5980((class_1309)player);
        }
        mob.method_5966();
    }

    private static Optional<class_1299<?>> getRandomEncounterData(class_3218 level, class_5138 structureManager, class_2794 chunkGenerator, class_1311 category, class_2338 pos) {
        class_6005<class_1299<?>> list = CommonConfigs.ENCOUNTER_WHITELIST.get();
        if (!list.method_34993()) {
            return list.method_34992(level.field_9229).map(class_6008.class_6010::comp_2542);
        }
        return class_6012.method_34988(class_1948.method_29950((class_3218)level, (class_5138)structureManager, (class_2794)chunkGenerator, (class_1311)category, (class_2338)pos, (class_6880)level.method_23753(pos)).method_34994().stream().filter(e -> !e.field_9389.method_20210(SleepTight.WAKE_UP_BLACKLIST)).toList()).method_34992(level.field_9229).map(e -> e.field_9389);
    }

    public static boolean trySpawningBedbug(class_2338 bedPos, class_3222 player, BedData data) {
        class_3218 level = (class_3218)player.method_37908();
        if (!level.method_8450().method_8355(class_1928.field_19390)) {
            return false;
        }
        double spawnChance = CommonConfigs.BEDBUG_SPAWN_CHANCE.get();
        if ((double)level.field_9229.method_43057() < spawnChance) {
            if (CommonConfigs.PREVENTED_BY_DREAM_CATCHER.get().booleanValue() && DreamEssenceBlock.isInRange(bedPos, (class_1937)level)) {
                return false;
            }
            if (CommonConfigs.ONLY_WHEN_IN_HOME_BED.get().booleanValue()) {
                PlayerSleepData playerData = STPlatStuff.getPlayerSleepData((class_1657)player);
                if (data == null || !playerData.isBedLastSleptInto(data)) {
                    return false;
                }
            }
            class_2338.class_2339 mutable = bedPos.method_25503();
            int monsterSpawnAttempts = CommonConfigs.BEDBUG_TRIES.get();
            int min = CommonConfigs.BEDBUG_SPAWN_MIN_RANGE.get();
            int max = CommonConfigs.BEDBUG_SPAWN_MAX_RANGE.get();
            int maxAttempts = (int)((float)monsterSpawnAttempts * (1.0f + level.method_8404(bedPos).method_5458()));
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                WakeUpEncounterHelper.setRandomPosCircle(bedPos, mutable, level.field_9229, min, max);
                BedbugEntity mob = (BedbugEntity)((Object)WakeUpEncounterHelper.createValidMobToSpawn(class_243.method_24953((class_2382)mutable), level, mutable, (class_1299)SleepTight.BEDBUG_ENTITY.get(), class_3730.field_16467));
                if (mob == null) continue;
                mob.method_24830(true);
                class_11 path = mob.method_5942().method_6348((class_2338)mutable, 0);
                if (path == null) continue;
                mob.setBedTarget((class_2338)mutable);
                WakeUpEncounterHelper.doSpawnMob(level, (class_1308)mob);
                return true;
            }
        }
        return false;
    }
}

