/*
 * Decompiled with CFR 0.152.
 */
package betterdays.time;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class MonotonicInterpolator {
    private final double[] x;
    private final double[] y;
    private final double[] m;
    private final double smoothingFactor;

    public MonotonicInterpolator(List<Pair<Integer, Double>> points, double smoothingFactor) {
        if (points.size() < 2) {
            throw new IllegalArgumentException("At least two points are required.");
        }
        int n = points.size();
        this.smoothingFactor = smoothingFactor;
        this.x = new double[n];
        this.y = new double[n];
        this.m = new double[n];
        for (int i = 0; i < n; ++i) {
            this.x[i] = ((Integer)points.get(i).getLeft()).intValue();
            this.y[i] = (Double)points.get(i).getRight();
        }
        this.computeMonotonicSlopes();
    }

    private void computeMonotonicSlopes() {
        int i;
        int n = this.x.length;
        double[] delta = new double[n - 1];
        for (i = 0; i < n - 1; ++i) {
            delta[i] = (this.y[i + 1] - this.y[i]) / (this.x[i + 1] - this.x[i]);
        }
        this.m[0] = delta[0];
        for (i = 1; i < n - 1; ++i) {
            this.m[i] = delta[i - 1] * delta[i] > 0.0 ? this.smoothingFactor * (delta[i - 1] + delta[i]) / 2.0 : 0.0;
        }
        this.m[n - 1] = delta[n - 2];
        for (i = 0; i < n - 1; ++i) {
            if (delta[i] == 0.0) {
                this.m[i] = 0.0;
                this.m[i + 1] = 0.0;
                continue;
            }
            double alpha = this.m[i] / delta[i];
            double beta = this.m[i + 1] / delta[i];
            double sum = alpha * alpha + beta * beta;
            if (!(sum > 9.0)) continue;
            double tau = 3.0 / Math.sqrt(sum);
            this.m[i] = tau * alpha * delta[i];
            this.m[i + 1] = tau * beta * delta[i];
        }
    }

    public double evaluate(double xValue) {
        if (xValue <= this.x[0]) {
            return this.y[0];
        }
        if (xValue >= this.x[this.x.length - 1]) {
            return this.y[this.y.length - 1];
        }
        int i = Arrays.binarySearch(this.x, xValue);
        if (i < 0) {
            i = -i - 2;
        }
        double h = this.x[i + 1] - this.x[i];
        double t = (xValue - this.x[i]) / h;
        double t2 = t * t;
        double t3 = t2 * t;
        double h00 = 2.0 * t3 - 3.0 * t2 + 1.0;
        double h10 = (t3 - 2.0 * t2 + t) * h;
        double h01 = -2.0 * t3 + 3.0 * t2;
        double h11 = (t3 - t2) * h;
        return h00 * this.y[i] + h10 * this.m[i] + h01 * this.y[i + 1] + h11 * this.m[i + 1];
    }
}

