/*
 * Decompiled with CFR 0.152.
 */
package betterdays.event;

import betterdays.message.BetterDaysMessages;
import betterdays.time.TimeServiceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class ServerEventListener {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDaySleepCheck(CanPlayerSleepEvent event) {
        if (TimeServiceManager.onDaySleepCheck((Level)event.getEntity().level())) {
            event.setProblem(null);
        }
    }

    @SubscribeEvent
    public void onSleepingCheckEvent(CanContinueSleepingEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BetterDaysMessages.onSleepingCheckEvent(player);
            if (TimeServiceManager.onSleepingCheckEvent(event.getEntity().level())) {
                event.setContinueSleeping(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUpEvent(PlayerWakeUpEvent event) {
        if (event.updateLevel()) {
            BetterDaysMessages.onPlayerWakeUpEvent(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onSleepFinishedEvent(SleepFinishedTimeEvent event) {
        BetterDaysMessages.onSleepFinishedEvent(event.getLevel());
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        TimeServiceManager.onWorldLoad(event.getLevel());
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        TimeServiceManager.onWorldUnload(event.getLevel());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldTick(LevelTickEvent.Pre event) {
        TimeServiceManager.onWorldTick((LevelAccessor)event.getLevel());
    }
}

