/*
 * Decompiled with CFR 0.152.
 */
package betterdays.time;

import betterdays.config.ConfigHandler;
import betterdays.time.Time;
import betterdays.time.TimeService;
import betterdays.wrappers.ServerLevelWrapper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class TimeServiceManager {
    public static TimeService service;
    public static final Time VANILLA_SLEEP_END;

    public static boolean onDaySleepCheck(Level level) {
        return service != null && ((ServerLevel)TimeServiceManager.service.level.get()).equals(level) && ConfigHandler.Common.enableSleepFeature() && ConfigHandler.Common.allowDaySleep();
    }

    public static boolean onSleepingCheckEvent(Level level) {
        if (service != null && ((ServerLevel)TimeServiceManager.service.level.get()).equals(level)) {
            Time time = service.getDayTime().timeOfDay();
            return ConfigHandler.Common.enableSleepFeature() && (time.compareTo(VANILLA_SLEEP_END) >= 0 || ConfigHandler.Common.allowDaySleep());
        }
        return false;
    }

    public static void onWorldLoad(LevelAccessor level) {
        ServerLevelWrapper wrappedLevel;
        if (ServerLevelWrapper.isServerLevel(level) && ((ServerLevel)(wrappedLevel = new ServerLevelWrapper(level)).get()).equals(((ServerLevel)wrappedLevel.get()).getServer().overworld())) {
            service = new TimeService(wrappedLevel);
        }
    }

    public static void onWorldUnload(LevelAccessor level) {
        if (service != null && TimeServiceManager.service.level.get() == level) {
            service = null;
        }
    }

    public static void onWorldTick(LevelAccessor level) {
        if (service != null && TimeServiceManager.service.level.get() == level) {
            service.tick();
        }
    }

    static {
        VANILLA_SLEEP_END = new Time(23460L);
    }
}

