/*
 * Decompiled with CFR 0.152.
 */
package betterdays.time.effects;

import betterdays.config.ConfigHandler;
import betterdays.time.SleepStatus;
import betterdays.time.TimeContext;
import betterdays.time.effects.AbstractTimeEffect;
import betterdays.time.effects.EffectCondition;
import betterdays.wrappers.ServerLevelWrapper;
import betterdays.wrappers.ServerPlayerWrapper;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class HungerTimeEffect
extends AbstractTimeEffect {
    @Override
    public void onTimeTick(TimeContext context) {
        EffectCondition condition = ConfigHandler.Common.hungerEffect();
        if (condition == EffectCondition.NEVER) {
            return;
        }
        ServerLevelWrapper level = context.getLevel();
        SleepStatus sleepStatus = context.getTimeService().sleepStatus;
        long extraTicks = context.getTimeDelta().longValue() - 1L;
        if (extraTicks <= 0L || condition == EffectCondition.SLEEPING && sleepStatus.allAwake()) {
            return;
        }
        Stream<ServerPlayerWrapper> playerStream = ((ServerLevel)level.get()).players().stream().map(ServerPlayerWrapper::new);
        if (condition == EffectCondition.SLEEPING) {
            playerStream = playerStream.filter(ServerPlayerWrapper::isSleeping);
        }
        playerStream.forEach(player -> HungerTimeEffect.tickHunger(player, extraTicks));
    }

    private static void tickHunger(ServerPlayerWrapper player, long ticks) {
        int i = 0;
        while ((long)i < ticks) {
            ((ServerPlayer)player.get()).getFoodData().tick((ServerPlayer)player.get());
            ++i;
        }
    }
}

