/*
 * Decompiled with CFR 0.152.
 */
package betterdays.registry;

import betterdays.platform.Services;
import betterdays.registry.RegistryObject;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public interface RegistryProvider<T> {
    public static <T> RegistryProvider<T> get(ResourceKey<? extends Registry<T>> resourceKey, String modId, boolean makeRegistry) {
        return Services.REGISTRY_FACTORY.create(resourceKey, modId, makeRegistry);
    }

    public static <T> RegistryProvider<T> get(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        return RegistryProvider.get(resourceKey, modId, false);
    }

    public static <T> RegistryProvider<T> get(Registry<T> registry, String modId, boolean makeRegistry) {
        return Services.REGISTRY_FACTORY.create(registry, modId, makeRegistry);
    }

    public static <T> RegistryProvider<T> get(Registry<T> registry, String modId) {
        return RegistryProvider.get(registry, modId, false);
    }

    public <I extends T> RegistryObject<I> register(String var1, Supplier<? extends I> var2);

    public Collection<RegistryObject<T>> getEntries();

    public String getModId();
}

