/*
 * Decompiled with CFR 0.152.
 */
package betterdays.time;

import betterdays.wrappers.ServerPlayerWrapper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_3222;
import net.minecraft.class_5838;

public class SleepStatus
extends class_5838 {
    protected int activePlayerCount;
    protected int sleepingPlayerCount;
    protected Supplier<Boolean> preventSleepSupplier;

    public SleepStatus(Supplier<Boolean> preventSleepSupplier) {
        this.preventSleepSupplier = preventSleepSupplier;
    }

    public void method_33811() {
        this.sleepingPlayerCount = 0;
    }

    public int method_33815() {
        return this.sleepingPlayerCount;
    }

    public int amountActive() {
        return this.activePlayerCount;
    }

    public boolean allAwake() {
        return this.sleepingPlayerCount == 0;
    }

    public boolean allAsleep() {
        return this.sleepingPlayerCount == this.activePlayerCount;
    }

    public double ratio() {
        return (double)this.sleepingPlayerCount / (double)this.activePlayerCount;
    }

    public int percentage() {
        return (int)(this.ratio() * 100.0);
    }

    public void updatePlayerCounts(List<class_3222> playerList) {
        this.activePlayerCount = 0;
        this.sleepingPlayerCount = 0;
        for (class_3222 player : playerList) {
            if (player.method_7325()) continue;
            ++this.activePlayerCount;
            if (!player.method_6113()) continue;
            ++this.sleepingPlayerCount;
        }
    }

    public int method_33816(int percentageRequired) {
        return Math.max(1, (int)Math.ceil((double)(this.activePlayerCount * percentageRequired) / 100.0));
    }

    public boolean method_33812(int percentageRequired) {
        if (this.preventSleepSupplier.get().booleanValue()) {
            return false;
        }
        return this.sleepingPlayerCount >= this.method_33816(percentageRequired);
    }

    public boolean method_33813(int percentageRequired, List<class_3222> playerList) {
        if (this.preventSleepSupplier.get().booleanValue()) {
            return false;
        }
        long deepSleepers = playerList.stream().map(ServerPlayerWrapper::new).filter(ServerPlayerWrapper::isSleepingLongEnough).count();
        return deepSleepers >= (long)this.method_33816(percentageRequired);
    }

    public boolean method_33814(List<class_3222> playerList) {
        int oldActiveCount = this.activePlayerCount;
        int oldSleepingCount = this.sleepingPlayerCount;
        this.updatePlayerCounts(playerList);
        if (this.preventSleepSupplier.get().booleanValue()) {
            return false;
        }
        boolean noSleepers = oldSleepingCount == 0 && this.sleepingPlayerCount == 0;
        boolean valueChanged = oldActiveCount != this.activePlayerCount || oldSleepingCount != this.sleepingPlayerCount;
        return !noSleepers && valueChanged;
    }
}

