/*
 * Decompiled with CFR 0.152.
 */
package betterdays.message;

import betterdays.config.ConfigHandler;
import betterdays.message.TemplateMessage;
import betterdays.time.SleepStatus;
import betterdays.time.TimeService;
import betterdays.time.TimeServiceManager;
import betterdays.wrappers.ServerLevelWrapper;
import betterdays.wrappers.ServerPlayerWrapper;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class BetterDaysMessages {
    public static void onSleepingCheckEvent(class_1657 player) {
        TimeService service = TimeServiceManager.service;
        if (ConfigHandler.Common.enableSleepFeature() && player.method_7297() == 2 && player.getClass() == ServerPlayerWrapper.playerClass && service != null && ((class_3218)service.level.get()).equals(player.method_73183()) && ((class_3218)service.level.get()).method_18456().size() > 1 && service.level.daylightRuleEnabled()) {
            BetterDaysMessages.sendEnterBedMessage(new ServerPlayerWrapper(player));
        }
    }

    public static void onPlayerWakeUpEvent(class_1657 player) {
        TimeService service = TimeServiceManager.service;
        if (ConfigHandler.Common.enableSleepFeature() && player.getClass() == ServerPlayerWrapper.playerClass && service != null && ((class_3218)service.level.get()).equals(player.method_73183()) && ((class_3218)service.level.get()).method_18456().size() > 1 && service.level.daylightRuleEnabled()) {
            BetterDaysMessages.sendLeaveBedMessage(new ServerPlayerWrapper(player));
        }
    }

    public static void onSleepFinishedEvent(class_1936 level) {
        TimeService service = TimeServiceManager.service;
        if (ConfigHandler.Common.enableSleepFeature() && service != null && ((class_3218)service.level.get()).equals(level) && service.level.daylightRuleEnabled()) {
            ServerLevelWrapper levelWrapper = new ServerLevelWrapper(level);
            BetterDaysMessages.sendMorningMessage(levelWrapper);
        }
    }

    public static void sendEnterBedMessage(ServerPlayerWrapper player) {
        String templateMessage = ConfigHandler.Common.enterBedMessage();
        TimeService timeService = TimeServiceManager.service;
        if (templateMessage.isEmpty() || timeService == null) {
            return;
        }
        SleepStatus sleepStatus = timeService.sleepStatus;
        new TemplateMessage().setTemplate(templateMessage).setOverlay(ConfigHandler.Common.enterBedMessageType().isOverlay()).setVariable("player", ((class_3222)player.get()).method_7334().name()).setVariable("totalPlayers", Integer.toString(sleepStatus.amountActive())).setVariable("sleepingPlayers", Integer.toString(sleepStatus.method_33815())).setVariable("sleepingPercentage", Integer.toString(sleepStatus.percentage())).bake().send(ConfigHandler.Common.enterBedMessageTarget(), player.getLevel());
    }

    public static void sendLeaveBedMessage(ServerPlayerWrapper player) {
        String templateMessage = ConfigHandler.Common.leaveBedMessage();
        TimeService timeService = TimeServiceManager.service;
        if (templateMessage.isEmpty() || timeService == null) {
            return;
        }
        SleepStatus sleepStatus = timeService.sleepStatus;
        new TemplateMessage().setTemplate(templateMessage).setOverlay(ConfigHandler.Common.leaveBedMessageType().isOverlay()).setVariable("player", ((class_3222)player.get()).method_7334().name()).setVariable("totalPlayers", Integer.toString(sleepStatus.amountActive())).setVariable("sleepingPlayers", Integer.toString(sleepStatus.method_33815() - 1)).setVariable("sleepingPercentage", Integer.toString(sleepStatus.percentage())).bake().send(ConfigHandler.Common.leaveBedMessageTarget(), player.getLevel());
    }

    public static void sendMorningMessage(ServerLevelWrapper level) {
        String templateMessage = ConfigHandler.Common.morningMessage();
        TimeService timeService = TimeServiceManager.service;
        if (templateMessage.isEmpty() || timeService == null) {
            return;
        }
        SleepStatus sleepStatus = timeService.sleepStatus;
        new TemplateMessage().setTemplate(templateMessage).setOverlay(ConfigHandler.Common.morningMessageType().isOverlay()).setVariable("totalPlayers", Integer.toString(sleepStatus.amountActive())).setVariable("sleepingPlayers", Integer.toString(sleepStatus.method_33815())).setVariable("sleepingPercentage", Integer.toString(sleepStatus.percentage())).bake().send(ConfigHandler.Common.morningMessageTarget(), level);
    }
}

