/*
 * Decompiled with CFR 0.152.
 */
package betterdays.platform;

import betterdays.platform.services.IRegistryFactory;
import betterdays.registry.RegistryObject;
import betterdays.registry.RegistryProvider;
import betterdays.registry.TimeEffectsRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class FabricRegistryProvider
implements IRegistryFactory {
    @Override
    public <T> RegistryProvider<T> create(class_5321<? extends class_2378<T>> resourceKey, String modId, boolean makeRegistry) {
        return new Provider(modId, resourceKey, makeRegistry);
    }

    @Override
    public <T> RegistryProvider<T> create(class_2378<T> registry, String modId, boolean makeRegistry) {
        return new Provider<T>(modId, registry, makeRegistry);
    }

    private static class Provider<T>
    implements RegistryProvider<T> {
        private final String modId;
        private final class_2378<T> registry;
        private final boolean makeRegistry;
        private final Set<RegistryObject<T>> entries = new HashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, class_5321<? extends class_2378<T>> key, boolean makeRegistry) {
            this.modId = modId;
            this.makeRegistry = makeRegistry;
            if (makeRegistry) {
                class_2370 reg;
                this.registry = reg = (class_2370)FabricRegistryBuilder.createSimple(TimeEffectsRegistry.class, (class_2960)key.method_29177()).buildAndRegister();
            } else {
                Optional reg = class_7923.field_41167.method_10223(key.method_29177());
                if (reg.isPresent()) {
                    this.registry = (class_2378)((class_6880.class_6883)reg.get()).comp_349();
                } else {
                    throw new RuntimeException("Registry with name " + String.valueOf(key.method_29177()) + " was not found!");
                }
            }
        }

        private Provider(String modId, class_2378<T> registry, boolean makeRegistry) {
            this.modId = modId;
            this.registry = registry;
            this.makeRegistry = makeRegistry;
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final class_2960 rl = class_2960.method_60655((String)this.modId, (String)name);
            final Object obj = class_2378.method_10230(this.registry, (class_2960)rl, supplier.get());
            RegistryObject ro = new RegistryObject<I>(){
                final class_5321<I> key;
                {
                    this.key = class_5321.method_29179((class_5321)registry.method_46765(), (class_2960)rl);
                }

                @Override
                public class_5321<I> getResourceKey() {
                    return this.key;
                }

                @Override
                public class_2960 getId() {
                    return rl;
                }

                @Override
                public I get() {
                    return obj;
                }

                @Override
                public class_6880<I> asHolder() {
                    Optional optionalReference = registry.method_46746(this.key);
                    if (optionalReference.isPresent()) {
                        return (class_6880)optionalReference.get();
                    }
                    throw new RuntimeException("Registry with name " + String.valueOf(this.key.method_29177()) + " was not found!");
                }
            };
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Collection<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public String getModId() {
            return this.modId;
        }
    }
}

