/*
 * Decompiled with CFR 0.152.
 */
package betterdays.time;

import betterdays.BetterDays;
import betterdays.config.ConfigHandler;
import betterdays.platform.ModLoader;
import betterdays.platform.Services;
import betterdays.registry.RegistryObject;
import betterdays.registry.TimeEffectsRegistry;
import betterdays.time.MonotonicInterpolator;
import betterdays.time.SleepStatus;
import betterdays.time.Time;
import betterdays.time.TimeContext;
import betterdays.time.effects.EffectCondition;
import betterdays.time.effects.TimeEffect;
import betterdays.utils.MathUtils;
import betterdays.wrappers.ServerLevelWrapper;
import betterdays.wrappers.TimePacketWrapper;
import java.util.Collection;
import net.minecraft.class_1936;
import net.minecraft.class_2596;
import net.minecraft.class_3218;

public class TimeService {
    public static final Time DAY_START = new Time(ConfigHandler.Common.dayStart());
    public static final Time NIGHT_START = new Time(ConfigHandler.Common.nightStart());
    private static final int OVERFLOW_THRESHOLD = 2147328000;
    private static MonotonicInterpolator monotonicInterpolator;
    public final ServerLevelWrapper level;
    public final SleepStatus sleepStatus;
    private double timeDecimalAccumulator = 0.0;

    public TimeService(ServerLevelWrapper level) {
        this.level = level;
        this.sleepStatus = new SleepStatus(ConfigHandler.Common::enableSleepFeature);
        this.level.setSleepStatus(this.sleepStatus);
        if (ConfigHandler.Common.enableInterpolatedTime()) {
            monotonicInterpolator = new MonotonicInterpolator(ConfigHandler.Common.interpolatedTimePairs(), ConfigHandler.Common.interpolatedTimeSmoothingFactor());
        }
    }

    public void tick() {
        if (!this.level.daylightRuleEnabled()) {
            return;
        }
        if (Services.PLATFORM.getModLoader() == ModLoader.NEOFORGE && this.sleepStatus.allAwake()) {
            Time time = this.getDayTime();
            double speed = this.getTimeSpeed(time);
            TimeContext context = new TimeContext(this, time, time);
            Services.PLATFORM.setTimeSpeed(this.level, (float)speed);
            this.tryResetRandomTickSpeed();
        } else {
            Time oldTime = this.getDayTime();
            Time deltaTime = this.tickTime();
            Time time = this.getDayTime();
            TimeContext context = new TimeContext(this, time, deltaTime);
            this.getActiveTimeEffects().forEach(effect -> ((TimeEffect)effect.get()).onTimeTick(context));
            this.preventTimeOverflow();
            this.broadcastTime();
            this.vanillaTimeCompensation();
            if (ConfigHandler.Common.enableSleepFeature() && !this.sleepStatus.allAwake() && Time.crossedMorning(oldTime, time)) {
                this.handleMorning();
            }
        }
    }

    private void tryResetRandomTickSpeed() {
        EffectCondition condition = ConfigHandler.Common.randomTickEffect();
        if (condition != EffectCondition.NEVER) {
            this.level.setRandomTickSpeed(ConfigHandler.Common.baseRandomTickSpeed());
        }
    }

    private void handleMorning() {
        long time = ((class_3218)this.level.get()).method_8532();
        Services.PLATFORM.onSleepFinished(this.level, time);
        this.sleepStatus.method_33811();
        this.level.wakeUpAllPlayers();
        if (this.level.weatherRuleEnabled() && ConfigHandler.Common.clearWeatherOnWake()) {
            this.level.stopWeather();
        }
        BetterDays.LOGGER.debug("Sleep cycle complete on dimension: {}.", (Object)((class_3218)this.level.get()).method_27983().method_29177());
    }

    private void vanillaTimeCompensation() {
        ((class_3218)this.level.get()).method_29199(((class_3218)this.level.get()).method_8532() - 1L);
    }

    private void preventTimeOverflow() {
        long time = ((class_3218)this.level.get()).method_8532();
        if (time > 2147328000L) {
            ((class_3218)this.level.get()).method_29199(time - 2147328000L);
        }
    }

    private Time tickTime() {
        Time time = this.getDayTime();
        Time timeDelta = new Time(this.getTimeSpeed(time));
        timeDelta = this.correctForOvershoot(time, timeDelta);
        this.setDayTime(time.add(timeDelta));
        return timeDelta;
    }

    private Time correctForOvershoot(Time time, Time timeDelta) {
        Time nextTime = time.add(timeDelta);
        Time timeOfDay = time.timeOfDay();
        Time nextTimeOfDay = nextTime.timeOfDay();
        if (this.sleepStatus.allAwake()) {
            if (NIGHT_START.betweenMod(timeOfDay, nextTimeOfDay)) {
                double nextTimeSpeed = this.getTimeSpeed(nextTime);
                Time timeUntilBreakpoint = NIGHT_START.subtract(timeOfDay);
                double breakpointRatio = 1.0 - timeUntilBreakpoint.divide(timeDelta);
                return timeUntilBreakpoint.add(nextTimeSpeed * breakpointRatio);
            }
            if (DAY_START.betweenMod(timeOfDay, nextTimeOfDay)) {
                double nextTimeSpeed = this.getTimeSpeed(nextTime);
                Time timeUntilBreakpoint = DAY_START.subtract(timeOfDay);
                double breakpointRatio = 1.0 - timeUntilBreakpoint.divide(timeDelta);
                return timeUntilBreakpoint.add(nextTimeSpeed * breakpointRatio);
            }
        } else {
            Time timeUntilMorning = Time.DAY_LENGTH.subtract(timeOfDay);
            if (timeUntilMorning.compareTo(timeDelta) < 0) {
                double nextTimeSpeed = ConfigHandler.Common.daySpeed();
                double breakpointRatio = 1.0 - timeUntilMorning.divide(timeDelta);
                return timeUntilMorning.add(nextTimeSpeed * breakpointRatio);
            }
        }
        return timeDelta;
    }

    public double getTimeSpeed(Time time) {
        if (!ConfigHandler.Common.enableSleepFeature() || this.sleepStatus.allAwake() || this.sleepStatus.ratio() < ConfigHandler.Common.percentPlayersForSleep()) {
            if (ConfigHandler.Common.enableInterpolatedTime()) {
                return monotonicInterpolator.evaluate(time.timeOfDay().longValue());
            }
            if (time.equals(DAY_START) || time.timeOfDay().betweenMod(DAY_START, NIGHT_START)) {
                return ConfigHandler.Common.daySpeed();
            }
            return ConfigHandler.Common.nightSpeed();
        }
        if (this.sleepStatus.allAsleep() && ConfigHandler.Common.sleepSpeedAll() >= 0.0) {
            return ConfigHandler.Common.sleepSpeedAll();
        }
        double sleepRatio = this.sleepStatus.ratio();
        double curve = ConfigHandler.Common.sleepSpeedCurve();
        double speedRatio = MathUtils.normalizedTunableSigmoid(sleepRatio, curve);
        double sleepSpeedMin = ConfigHandler.Common.sleepSpeedMin();
        double sleepSpeedMax = ConfigHandler.Common.sleepSpeedMax();
        double multiplier = MathUtils.lerp(speedRatio, sleepSpeedMin, sleepSpeedMax);
        return multiplier;
    }

    public Time getDayTime() {
        return new Time(((class_3218)this.level.get()).method_8532(), this.timeDecimalAccumulator);
    }

    public Time setDayTime(Time time) {
        this.timeDecimalAccumulator = time.fractionalValue();
        ((class_3218)this.level.get()).method_29199(time.longValue());
        return time;
    }

    public void broadcastTime() {
        TimePacketWrapper timePacket = TimePacketWrapper.create(this.level);
        ((class_3218)this.level.get()).method_8503().method_3760().method_14571().stream().filter(player -> this.managesLevel(new ServerLevelWrapper((class_1936)player.method_51469()))).forEach(player -> player.field_13987.method_14364((class_2596)timePacket.get()));
    }

    public boolean managesLevel(ServerLevelWrapper levelToCheck) {
        if (((class_3218)this.level.get()).equals(levelToCheck.get())) {
            return true;
        }
        return ((class_3218)this.level.get()).equals(((class_3218)this.level.get()).method_8503().method_30002()) && ServerLevelWrapper.isDerived((class_1936)levelToCheck.get());
    }

    private Collection<RegistryObject<TimeEffect>> getActiveTimeEffects() {
        return TimeEffectsRegistry.TIME_EFFECT_REGISTRY.getEntries();
    }
}

