/*
 * Decompiled with CFR 0.152.
 */
package betterdays.config;

import betterdays.client.gui.ScreenAlignment;
import betterdays.common.Translations;
import betterdays.config.SpeedMethod;
import betterdays.message.ChatTypeOptions;
import betterdays.message.TemplateMessage;
import betterdays.time.Time;
import betterdays.time.effects.EffectCondition;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;
import technology.roughness.whitenoise.platform.Services;

public class ConfigHandler {
    public static final WhiteNoiseConfigSpec CLIENT_SPEC;
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Client CLIENT;
    private static final Common COMMON;

    public static void init() {
        for (String dimensionKey : (List)ConfigHandler.CLIENT.blacklistDimensions.get()) {
            Client.blacklistDimensionsSet.add(class_2960.method_12829((String)dimensionKey));
        }
    }

    private static String getTranslation(String key) {
        return Translations.get(key);
    }

    private static String getTranslation(String key, String ... values) {
        return Translations.get(key, values);
    }

    static {
        Pair specPairClient = new WhiteNoiseConfigSpec.Builder().configure(Client::new);
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        CLIENT_SPEC = (WhiteNoiseConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static class Client {
        private final WhiteNoiseConfigSpec.EnumValue<ScreenAlignment> clockAlignment;
        private final WhiteNoiseConfigSpec.IntValue clockScale;
        private final WhiteNoiseConfigSpec.IntValue clockMargin;
        private final WhiteNoiseConfigSpec.BooleanValue preventClockWobble;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> blacklistDimensions;
        private static final List<String> blacklistDimensionsList = List.of("blacklistDimensions");
        private static final String[] defaultBlacklistDimensions = new String[]{"aether:the_aether"};
        private static final Set<class_2960> blacklistDimensionsSet = Sets.newHashSet();
        private static final Predicate<Object> resourceLocationValidator = s -> s instanceof String && ((String)s).matches("[a-z]+[:]{1}[a-z_]+");

        public Client(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("gui").comment(ConfigHandler.getTranslation("gui"));
            this.clockAlignment = builder.comment(ConfigHandler.getTranslation("clockalignment")).defineEnum("clockAlignment", (Enum)ScreenAlignment.TOP_RIGHT);
            this.clockScale = builder.comment(ConfigHandler.getTranslation("clockscale")).defineInRange("clockScale", 64, 1, Integer.MAX_VALUE);
            this.clockMargin = builder.comment(ConfigHandler.getTranslation("clockmargin")).defineInRange("clockMargin", 16, 0, Integer.MAX_VALUE);
            this.preventClockWobble = builder.comment(new String[]{ConfigHandler.getTranslation("preventclockwobble"), ConfigHandler.getTranslation("preventclockwobble.comment")}).define("preventClockWobble", true);
            this.blacklistDimensions = builder.comment(ConfigHandler.getTranslation("blacklistdimensions")).defineListAllowEmpty(blacklistDimensionsList, Client.getBlacklistDimensionsList(), resourceLocationValidator);
            builder.pop();
        }

        public static ScreenAlignment clockAlignment() {
            return (ScreenAlignment)((Object)ConfigHandler.CLIENT.clockAlignment.get());
        }

        public static int clockScale() {
            return (Integer)ConfigHandler.CLIENT.clockScale.get();
        }

        public static int clockMargin() {
            return (Integer)ConfigHandler.CLIENT.clockMargin.get();
        }

        public static boolean preventClockWobble() {
            return (Boolean)ConfigHandler.CLIENT.preventClockWobble.get();
        }

        public static Set<class_2960> getBlacklistDimensions() {
            return blacklistDimensionsSet;
        }

        private static Supplier<List<? extends String>> getBlacklistDimensionsList() {
            return () -> Arrays.asList(defaultBlacklistDimensions);
        }
    }

    public static class Common {
        private final WhiteNoiseConfigSpec.EnumValue<SpeedMethod> speedMethod;
        private final WhiteNoiseConfigSpec.DoubleValue daySpeed;
        private final WhiteNoiseConfigSpec.DoubleValue nightSpeed;
        private final WhiteNoiseConfigSpec.DoubleValue daySpeedMinutes;
        private final WhiteNoiseConfigSpec.DoubleValue nightSpeedMinutes;
        private final WhiteNoiseConfigSpec.DoubleValue dayStart;
        private final WhiteNoiseConfigSpec.DoubleValue nightStart;
        private final WhiteNoiseConfigSpec.BooleanValue enableInterpolatedTime;
        private final WhiteNoiseConfigSpec.DoubleValue interpolatedTimeSmoothingFactor;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> interpolatedTimePairs;
        private static final List<String> defaultInterpolatedTimePairs = List.of(new String[]{"0,1.0", "24000,1.0"});
        private static final Predicate<Object> valuePairValidator = s -> s instanceof String && ((String)s).matches("\\d+,\\d*\\.?\\d+");
        private final WhiteNoiseConfigSpec.EnumValue<EffectCondition> weatherEffect;
        private final WhiteNoiseConfigSpec.EnumValue<EffectCondition> randomTickEffect;
        private final WhiteNoiseConfigSpec.IntValue baseRandomTickSpeed;
        private final WhiteNoiseConfigSpec.EnumValue<EffectCondition> potionEffect;
        private final WhiteNoiseConfigSpec.EnumValue<EffectCondition> hungerEffect;
        private final WhiteNoiseConfigSpec.EnumValue<EffectCondition> blockEntityEffect;
        private final WhiteNoiseConfigSpec.BooleanValue enableSleepFeature;
        private final WhiteNoiseConfigSpec.DoubleValue sleepSpeedMin;
        private final WhiteNoiseConfigSpec.DoubleValue sleepSpeedMax;
        private final WhiteNoiseConfigSpec.DoubleValue sleepSpeedAll;
        private final WhiteNoiseConfigSpec.DoubleValue sleepSpeedCurve;
        private final WhiteNoiseConfigSpec.BooleanValue clearWeatherOnWake;
        private final WhiteNoiseConfigSpec.BooleanValue allowDaySleep;
        private final WhiteNoiseConfigSpec.BooleanValue displayBedClock;
        private final WhiteNoiseConfigSpec.DoubleValue ratioPlayersForSleep;
        private final WhiteNoiseConfigSpec.ConfigValue<String> morningMessage;
        private final WhiteNoiseConfigSpec.EnumValue<ChatTypeOptions> morningMessageType;
        private final WhiteNoiseConfigSpec.EnumValue<TemplateMessage.MessageTarget> morningMessageTarget;
        private final WhiteNoiseConfigSpec.ConfigValue<String> enterBedMessage;
        private final WhiteNoiseConfigSpec.EnumValue<ChatTypeOptions> enterBedMessageType;
        private final WhiteNoiseConfigSpec.EnumValue<TemplateMessage.MessageTarget> enterBedMessageTarget;
        private final WhiteNoiseConfigSpec.ConfigValue<String> leaveBedMessage;
        private final WhiteNoiseConfigSpec.EnumValue<ChatTypeOptions> leaveBedMessageType;
        private final WhiteNoiseConfigSpec.EnumValue<TemplateMessage.MessageTarget> leaveBedMessageTarget;
        private static final Function<List<? extends String>, List<Pair<Integer, Double>>> pairTransformer = list -> list.stream().map(entry -> {
            String[] parts = entry.split(",");
            if (parts.length == 2) {
                try {
                    int first = Integer.parseInt(parts[0].trim());
                    double second = Double.parseDouble(parts[1].trim());
                    return Pair.of((Object)first, (Object)second);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }).collect(Collectors.toList());

        public Common(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("time").comment(ConfigHandler.getTranslation("time"));
            this.speedMethod = builder.comment(ConfigHandler.getTranslation("speedmethod")).defineEnum("speedMethod", (Enum)SpeedMethod.RATIO);
            this.daySpeed = builder.comment(ConfigHandler.getTranslation("dayspeed")).defineInRange("daySpeed", 1.0, 0.0, Time.DAY_LENGTH.doubleValue());
            this.nightSpeed = builder.comment(ConfigHandler.getTranslation("nightspeed")).defineInRange("nightSpeed", 1.0, 0.0, Time.DAY_LENGTH.doubleValue());
            this.daySpeedMinutes = builder.comment(ConfigHandler.getTranslation("dayspeedminutes")).defineInRange("daySpeedMinutes", 10.0, 0.1, 10000.0);
            this.nightSpeedMinutes = builder.comment(ConfigHandler.getTranslation("nightspeedminutes")).defineInRange("nightSpeedMinutes", 10.0, 0.1, 10000.0);
            this.dayStart = builder.comment(ConfigHandler.getTranslation("daystart")).defineInRange("dayStart", 23500.0, 22300.0, 24000.0);
            this.nightStart = builder.comment(ConfigHandler.getTranslation("nightstart")).defineInRange("nightStart", 12500.0, 12000.0, 13000.0);
            this.enableInterpolatedTime = builder.comment(ConfigHandler.getTranslation("enableinterpolatedtime")).define("enableInterpolatedTime", false);
            this.interpolatedTimeSmoothingFactor = builder.comment(ConfigHandler.getTranslation("interpolatedtimesmoothingfactor")).defineInRange("interpolatedTimeSmoothingFactor", 0.25, 0.0, 10.0);
            this.interpolatedTimePairs = builder.comment(ConfigHandler.getTranslation("interpolatedtimelist")).defineList("interpolatedTimeList", defaultInterpolatedTimePairs, valuePairValidator);
            builder.push("effects").comment(ConfigHandler.getTranslation("effects"));
            this.weatherEffect = builder.comment(new String[]{ConfigHandler.getTranslation("weathereffect"), ConfigHandler.getTranslation("weathereffect.comment")}).defineEnum("weatherEffect", (Enum)EffectCondition.SLEEPING);
            this.randomTickEffect = builder.comment(new String[]{ConfigHandler.getTranslation("randomtickeffect"), ConfigHandler.getTranslation("randomtickeffect.comment")}).defineEnum("randomTickEffect", (Enum)EffectCondition.NEVER);
            this.baseRandomTickSpeed = builder.comment(ConfigHandler.getTranslation("baserandomtickspeed")).defineInRange("baseRandomTickSpeed", 3, 0, Integer.MAX_VALUE);
            this.potionEffect = builder.comment(new String[]{ConfigHandler.getTranslation("potioneffect"), ConfigHandler.getTranslation("potioneffect.comment")}).defineEnum("potionEffect", (Enum)EffectCondition.NEVER);
            this.hungerEffect = builder.comment(new String[]{ConfigHandler.getTranslation("hungereffect"), ConfigHandler.getTranslation("hungereffect.comment")}).defineEnum("hungerEffect", (Enum)EffectCondition.NEVER);
            this.blockEntityEffect = builder.comment(new String[]{ConfigHandler.getTranslation("blockentityeffect"), ConfigHandler.getTranslation("blockentityeffect.comment")}).defineEnum("blockEntityEffect", (Enum)EffectCondition.NEVER);
            builder.pop();
            builder.pop();
            builder.push("sleep");
            this.enableSleepFeature = builder.comment(ConfigHandler.getTranslation("enablesleepfeature")).define("enableSleepFeature", true);
            this.sleepSpeedMax = builder.comment(ConfigHandler.getTranslation("sleepspeedmax")).defineInRange("sleepSpeedMax", 110.0, 0.0, Time.DAY_LENGTH.doubleValue());
            this.sleepSpeedMin = builder.comment(ConfigHandler.getTranslation("sleepspeedmin")).defineInRange("sleepSpeedMin", 1.0, 0.0, Time.DAY_LENGTH.doubleValue());
            this.sleepSpeedAll = builder.comment(ConfigHandler.getTranslation("sleepspeedall")).defineInRange("sleepSpeedAll", -1.0, -1.0, Time.DAY_LENGTH.doubleValue());
            this.sleepSpeedCurve = builder.comment(new String[]{ConfigHandler.getTranslation("sleepspeedcurve"), ConfigHandler.getTranslation("sleepspeedcurve.comment")}).defineInRange("sleepSpeedCurve", 0.3, 0.0, 1.0);
            this.clearWeatherOnWake = builder.comment(ConfigHandler.getTranslation("clearweatheronwake")).define("clearWeatherOnWake", true);
            this.allowDaySleep = builder.comment(ConfigHandler.getTranslation("allowdaysleep")).define("allowDaySleep", false);
            this.displayBedClock = builder.comment(ConfigHandler.getTranslation("displaybedclock")).define("displayBedClock", true);
            this.ratioPlayersForSleep = builder.comment(ConfigHandler.getTranslation("ratioplayersforsleep")).defineInRange("ratioPlayersForSleep", 0.0, 0.0, 1.0);
            builder.comment(new String[]{ConfigHandler.getTranslation("messages"), ConfigHandler.getTranslation("messages.comment")}).push("messages");
            builder.comment(ConfigHandler.getTranslation("morning")).push("morning");
            this.morningMessage = builder.comment(ConfigHandler.getTranslation("message", "", "were", "were")).define("message", (Object)"\u00a7e\u00a7oTempus fugit!");
            this.morningMessageType = builder.comment(ConfigHandler.getTranslation("type")).defineEnum("type", (Enum)ChatTypeOptions.GAME_INFO);
            this.morningMessageTarget = builder.comment(ConfigHandler.getTranslation("target", ConfigHandler.getTranslation("target.morning"))).defineEnum("target", (Enum)TemplateMessage.MessageTarget.DIMENSION);
            builder.pop();
            builder.comment(ConfigHandler.getTranslation("enterbed")).push("enterBed");
            this.enterBedMessage = builder.comment(ConfigHandler.getTranslation("message", ConfigHandler.getTranslation("message.enterbed"), "are", "are")).define("message", (Object)"${player} is now sleeping. [${sleepingPlayers}/${totalPlayers}]");
            this.enterBedMessageType = builder.comment(ConfigHandler.getTranslation("type")).defineEnum("type", (Enum)ChatTypeOptions.GAME_INFO);
            this.enterBedMessageTarget = builder.comment(ConfigHandler.getTranslation("target", "")).defineEnum("target", (Enum)TemplateMessage.MessageTarget.DIMENSION);
            builder.pop();
            builder.comment(ConfigHandler.getTranslation("leavebed")).push("leaveBed");
            this.leaveBedMessage = builder.comment(ConfigHandler.getTranslation("message", ConfigHandler.getTranslation("message.leavebed"), "are", "are")).define("message", (Object)"${player} has left their bed. [${sleepingPlayers}/${totalPlayers}]");
            this.leaveBedMessageType = builder.comment(ConfigHandler.getTranslation("type")).defineEnum("type", (Enum)ChatTypeOptions.GAME_INFO);
            this.leaveBedMessageTarget = builder.comment(ConfigHandler.getTranslation("target", "")).defineEnum("target", (Enum)TemplateMessage.MessageTarget.DIMENSION);
            builder.pop();
            builder.pop();
            builder.pop();
        }

        public static double daySpeed() {
            if (ConfigHandler.COMMON.speedMethod.get() == SpeedMethod.MINUTES) {
                return 100.0 / (Double)ConfigHandler.COMMON.daySpeedMinutes.get() / 10.0;
            }
            if (ConfigHandler.COMMON.speedMethod.get() == SpeedMethod.REALTIME) {
                return 0.01388888992369175;
            }
            return (Double)ConfigHandler.COMMON.daySpeed.get();
        }

        public static double nightSpeed() {
            if (ConfigHandler.COMMON.speedMethod.get() == SpeedMethod.MINUTES) {
                return 100.0 / (Double)ConfigHandler.COMMON.nightSpeedMinutes.get() / 10.0;
            }
            if (ConfigHandler.COMMON.speedMethod.get() == SpeedMethod.REALTIME) {
                return 0.01388888992369175;
            }
            return (Double)ConfigHandler.COMMON.nightSpeed.get();
        }

        public static double dayStart() {
            return (Double)ConfigHandler.COMMON.dayStart.get();
        }

        public static double nightStart() {
            return (Double)ConfigHandler.COMMON.nightStart.get();
        }

        public static boolean enableInterpolatedTime() {
            return (Boolean)ConfigHandler.COMMON.enableInterpolatedTime.get();
        }

        public static double interpolatedTimeSmoothingFactor() {
            return (Double)ConfigHandler.COMMON.interpolatedTimeSmoothingFactor.get();
        }

        public static List<Pair<Integer, Double>> interpolatedTimePairs() {
            return pairTransformer.apply((List)ConfigHandler.COMMON.interpolatedTimePairs.get());
        }

        public static EffectCondition weatherEffect() {
            return (EffectCondition)((Object)ConfigHandler.COMMON.weatherEffect.get());
        }

        public static EffectCondition randomTickEffect() {
            return (EffectCondition)((Object)ConfigHandler.COMMON.randomTickEffect.get());
        }

        public static int baseRandomTickSpeed() {
            return (Integer)ConfigHandler.COMMON.baseRandomTickSpeed.get();
        }

        public static EffectCondition potionEffect() {
            return (EffectCondition)((Object)ConfigHandler.COMMON.potionEffect.get());
        }

        public static EffectCondition hungerEffect() {
            return (EffectCondition)((Object)ConfigHandler.COMMON.hungerEffect.get());
        }

        public static EffectCondition blockEntityEffect() {
            return (EffectCondition)((Object)ConfigHandler.COMMON.blockEntityEffect.get());
        }

        public static boolean enableSleepFeature() {
            boolean sleepModLoaded = Services.PLATFORM.isModLoaded("sleepwarp") || Services.PLATFORM.isModLoaded("sleep_tight");
            return !sleepModLoaded ? (Boolean)ConfigHandler.COMMON.enableSleepFeature.get() : false;
        }

        public static double sleepSpeedMin() {
            return (Double)ConfigHandler.COMMON.sleepSpeedMin.get();
        }

        public static double sleepSpeedMax() {
            return (Double)ConfigHandler.COMMON.sleepSpeedMax.get();
        }

        public static double sleepSpeedAll() {
            return (Double)ConfigHandler.COMMON.sleepSpeedAll.get();
        }

        public static double sleepSpeedCurve() {
            return (Double)ConfigHandler.COMMON.sleepSpeedCurve.get();
        }

        public static boolean clearWeatherOnWake() {
            return (Boolean)ConfigHandler.COMMON.clearWeatherOnWake.get();
        }

        public static boolean allowDaySleep() {
            return (Boolean)ConfigHandler.COMMON.allowDaySleep.get();
        }

        public static boolean displayBedClock() {
            return (Boolean)ConfigHandler.COMMON.displayBedClock.get();
        }

        public static double percentPlayersForSleep() {
            return (Double)ConfigHandler.COMMON.ratioPlayersForSleep.get();
        }

        public static String morningMessage() {
            return (String)ConfigHandler.COMMON.morningMessage.get();
        }

        public static ChatTypeOptions morningMessageType() {
            return (ChatTypeOptions)((Object)ConfigHandler.COMMON.morningMessageType.get());
        }

        public static TemplateMessage.MessageTarget morningMessageTarget() {
            return (TemplateMessage.MessageTarget)((Object)ConfigHandler.COMMON.morningMessageTarget.get());
        }

        public static String enterBedMessage() {
            return (String)ConfigHandler.COMMON.enterBedMessage.get();
        }

        public static ChatTypeOptions enterBedMessageType() {
            return (ChatTypeOptions)((Object)ConfigHandler.COMMON.enterBedMessageType.get());
        }

        public static TemplateMessage.MessageTarget enterBedMessageTarget() {
            return (TemplateMessage.MessageTarget)((Object)ConfigHandler.COMMON.enterBedMessageTarget.get());
        }

        public static String leaveBedMessage() {
            return (String)ConfigHandler.COMMON.leaveBedMessage.get();
        }

        public static ChatTypeOptions leaveBedMessageType() {
            return (ChatTypeOptions)((Object)ConfigHandler.COMMON.leaveBedMessageType.get());
        }

        public static TemplateMessage.MessageTarget leaveBedMessageTarget() {
            return (TemplateMessage.MessageTarget)((Object)ConfigHandler.COMMON.leaveBedMessageTarget.get());
        }
    }
}

