/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.StructurePlacement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PiecedStructure
extends Structure {
    public static final MapCodec<PiecedStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Structure.StructureSettings.CODEC.forGetter(structure -> structure.modifiableStructureInfo().getOriginalStructureInfo().structureSettings()), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)7).fieldOf("max_depth").forGetter(structure -> structure.maxDepth), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)StructurePlacement.CODEC.fieldOf("placement").forGetter(s -> s.placement)).apply((Applicative)instance, PiecedStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final int maxDepth;
    private final int maxDistanceFromCenter;
    private final StructurePlacement placement;

    public PiecedStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth, int maxDistanceFromCenter, StructurePlacement placement) {
        super(settings);
        this.startPool = startPool;
        this.maxDepth = maxDepth;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.placement = placement;
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        StructurePoolElement element = ((StructureTemplatePool)this.startPool.value()).getRandomTemplate((RandomSource)context.random());
        if (element == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        int x = context.chunkPos().getBlockX(context.random().nextInt(16));
        int z = context.chunkPos().getBlockZ(context.random().nextInt(16));
        Rotation rotation = Rotation.getRandom((RandomSource)context.random());
        BoundingBox boundingBox = element.getBoundingBox(context.structureTemplateManager(), new BlockPos(x, 0, z), rotation);
        Optional<Integer> height = this.placement.findHeight(context, boundingBox);
        if (height.isEmpty()) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(x, height.get() + 1, z);
        return PiecedStructure.addPieces(context, element, rotation, this.maxDepth, pos, this.maxDistanceFromCenter);
    }

    public StructureType<?> type() {
        return (StructureType)FormationsStructures.PIECED_STRUCTURE.get();
    }

    private static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, StructurePoolElement startElement, Rotation rotation, int maxDepth, BlockPos pos, int maxDistanceFromCenter) {
        if (startElement == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        StructureTemplateManager templateManager = context.structureTemplateManager();
        LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
        WorldgenRandom random = context.random();
        Registry registry = context.registryAccess().lookupOrThrow(Registries.TEMPLATE_POOL);
        PoolElementStructurePiece structurePiece = new PoolElementStructurePiece(templateManager, startElement, pos, startElement.getGroundLevelDelta(), rotation, startElement.getBoundingBox(templateManager, pos, rotation), LiquidSettings.APPLY_WATERLOGGING);
        BoundingBox boundingBox = structurePiece.getBoundingBox();
        int centeredX = (boundingBox.maxX() + boundingBox.minX()) / 2;
        int centeredZ = (boundingBox.maxZ() + boundingBox.minZ()) / 2;
        int heightOffset = boundingBox.minY() + structurePiece.getGroundLevelDelta();
        structurePiece.move(0, pos.getY() - heightOffset, 0);
        BlockPos centeredPos = new BlockPos(centeredX, pos.getY(), centeredZ);
        return Optional.of(new Structure.GenerationStub(centeredPos, piecesBuilder -> {
            piecesBuilder.addPiece((StructurePiece)structurePiece);
            if (maxDepth <= 0) {
                return;
            }
            VoxelShape allowedSpace = Shapes.join((VoxelShape)Shapes.create((AABB)new AABB(centeredPos).inflate((double)maxDistanceFromCenter)), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)boundingBox)), (BooleanOp)BooleanOp.ONLY_FIRST);
            ArrayList pieces = Lists.newArrayList();
            JigsawPlacement.addPieces((RandomState)context.randomState(), (int)maxDepth, (boolean)false, (ChunkGenerator)chunkGenerator, (StructureTemplateManager)templateManager, (LevelHeightAccessor)levelHeightAccessor, (RandomSource)random, (Registry)registry, (PoolElementStructurePiece)structurePiece, (List)pieces, (VoxelShape)allowedSpace, (PoolAliasLookup)PoolAliasLookup.EMPTY, (LiquidSettings)LiquidSettings.APPLY_WATERLOGGING);
            pieces.forEach(arg_0 -> ((StructurePiecesBuilder)piecesBuilder).addPiece(arg_0));
        }));
    }
}

