/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;

public class EnchantmentHelper {
    public static ItemStack getRandomEnchantedBook(int levels, boolean allowMultiple, boolean allowCurses, boolean allowTreasure, RandomSource random, RegistryAccess registryAccess) {
        return EnchantmentHelper.enchantItem(new ItemStack((ItemLike)Items.BOOK), levels, allowMultiple, allowCurses, allowTreasure, random, registryAccess);
    }

    public static ItemStack enchantItem(ItemStack stack, int levels, boolean allowMultiple, boolean allowCurses, boolean allowTreasure, RandomSource random, RegistryAccess registryAccess) {
        Stream<Holder> options = registryAccess.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentTags.ON_RANDOM_LOOT).stream().filter(Holder::isBound);
        if (!allowCurses) {
            options = options.filter(holder -> !holder.is(EnchantmentTags.CURSE));
        }
        if (!allowTreasure) {
            options = options.filter(holder -> !holder.is(EnchantmentTags.TREASURE));
        }
        List enchantments = net.minecraft.world.item.enchantment.EnchantmentHelper.selectEnchantment((RandomSource)random, (ItemStack)stack, (int)levels, options);
        if (stack.is(Items.BOOK)) {
            stack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        }
        if (allowMultiple) {
            for (EnchantmentInstance enchantment : enchantments) {
                stack.enchant(enchantment.enchantment(), enchantment.level());
            }
        } else {
            EnchantmentInstance enchantment = (EnchantmentInstance)enchantments.get(0);
            stack.enchant(enchantment.enchantment(), enchantment.level());
        }
        return stack;
    }
}

