/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.loot_table;

import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;

public class SetLootTablePacket
implements BasePacket {
    private BlockPos pos;
    private Identifier lootTable;

    public SetLootTablePacket(BlockPos pos, Identifier lootTable) {
        this.pos = pos;
        this.lootTable = lootTable;
    }

    public SetLootTablePacket() {
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeBoolean(this.lootTable != null);
        if (this.lootTable != null) {
            buffer.writeIdentifier(this.lootTable);
        }
    }

    public void read(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.lootTable = buffer.readBoolean() ? buffer.readIdentifier() : null;
    }

    public void handle(PacketContext context) {
        BlockEntity entity;
        if (context.getHandlingSide() == CoreSide.SERVER && context.getSendingPlayer().blockPosition().distManhattan((Vec3i)this.pos) <= 32 && (entity = context.getWorld().getBlockEntity(this.pos)) instanceof RandomizableContainerBlockEntity) {
            ((Clearable)entity).clearContent();
            ((RandomizableContainerBlockEntity)entity).setLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)this.lootTable), 0L);
            entity.setChanged();
        }
    }
}

