/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.supermartijn642.formations.tools.template.TemplateManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class TemplateManagerSaveData
extends SavedData {
    private static final String IDENTIFIER = "formations_templates";
    private final TemplateManager manager;

    public static void init(ServerLevel level, final TemplateManager manager) {
        level.getDataStorage().computeIfAbsent(new SavedDataType(IDENTIFIER, () -> new TemplateManagerSaveData(manager), (Codec)new Codec<TemplateManagerSaveData>(){

            public <T> DataResult<Pair<TemplateManagerSaveData, T>> decode(DynamicOps<T> ops, T input) {
                try {
                    TemplateManagerSaveData saveData = new TemplateManagerSaveData(manager);
                    saveData.load((CompoundTag)ops.convertTo((DynamicOps)NbtOps.INSTANCE, input));
                    return DataResult.success((Object)Pair.of((Object)((Object)saveData), input));
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }

            public <T> DataResult<T> encode(TemplateManagerSaveData input, DynamicOps<T> ops, T prefix) {
                try {
                    return DataResult.success((Object)NbtOps.INSTANCE.convertTo(ops, (Tag)input.save()));
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }
        }, null));
    }

    public TemplateManagerSaveData(TemplateManager manager) {
        this.manager = manager;
    }

    public CompoundTag save() {
        return this.manager.write();
    }

    public void load(CompoundTag tag) {
        this.manager.read(tag);
    }

    public boolean isDirty() {
        return true;
    }
}

