/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.momirealms.craftengine.bukkit.item.BukkitCustomItem;
import net.momirealms.craftengine.bukkit.item.ComponentTypes;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.ComponentKeys;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.NetworkItemHandler;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.ContextKey;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import net.momirealms.craftengine.libraries.nbt.StringTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.bukkit.inventory.ItemStack;

public final class ModernNetworkItemHandler
implements NetworkItemHandler<ItemStack> {
    @Override
    public Optional<Item<ItemStack>> c2s(Item<ItemStack> wrapped) {
        CompoundTag networkData;
        BukkitCustomItem customItem;
        Tag customData = wrapped.getSparrowNBTComponent(ComponentTypes.CUSTOM_DATA);
        if (!(customData instanceof CompoundTag)) {
            return Optional.empty();
        }
        CompoundTag compoundTag = (CompoundTag)customData;
        Optional<CustomItem<ItemStack>> optionalCustomItem = wrapped.getCustomItem();
        boolean hasDifferentMaterial = false;
        if (optionalCustomItem.isPresent() && (customItem = (BukkitCustomItem)optionalCustomItem.get()).item() != FastNMS.INSTANCE.method$ItemStack$getItem(wrapped.getLiteralObject())) {
            wrapped = wrapped.unsafeTransmuteCopy(customItem.item(), wrapped.count());
            hasDifferentMaterial = true;
        }
        if ((networkData = compoundTag.getCompound("craftengine:network_modifiers")) == null) {
            if (hasDifferentMaterial) {
                return Optional.of(wrapped);
            }
            return Optional.empty();
        }
        compoundTag.remove("craftengine:network_modifiers");
        for (Map.Entry<String, Tag> entry : networkData.entrySet()) {
            Tag tag = entry.getValue();
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag tag2 = (CompoundTag)tag;
            NetworkItemHandler.apply(entry.getKey(), tag2, wrapped);
        }
        if (compoundTag.isEmpty()) {
            wrapped.resetComponent(ComponentTypes.CUSTOM_DATA);
        } else {
            wrapped.setNBTComponent(ComponentTypes.CUSTOM_DATA, compoundTag);
        }
        return Optional.of(wrapped);
    }

    @Override
    public Optional<Item<ItemStack>> s2c(Item<ItemStack> wrapped, Player player) {
        ItemBuildContext context;
        boolean hasDifferentMaterial;
        Item<ItemStack> original = wrapped;
        Optional<CustomItem<ItemStack>> optionalCustomItem = wrapped.getCustomItem();
        if (optionalCustomItem.isEmpty()) {
            if (!Config.interceptItem()) {
                return Optional.empty();
            }
            return new OtherItem(wrapped, false).process();
        }
        BukkitCustomItem customItem = (BukkitCustomItem)optionalCustomItem.get();
        Object serverItem = FastNMS.INSTANCE.method$ItemStack$getItem(wrapped.getLiteralObject());
        boolean bl = hasDifferentMaterial = serverItem == customItem.item() && serverItem != customItem.clientItem();
        if (hasDifferentMaterial) {
            wrapped = wrapped.unsafeTransmuteCopy(customItem.clientItem(), wrapped.count());
        }
        if (!customItem.hasClientBoundDataModifier()) {
            if (!Config.interceptItem() && !hasDifferentMaterial) {
                return Optional.empty();
            }
            return new OtherItem(wrapped, hasDifferentMaterial).process();
        }
        CompoundTag customData = Optional.ofNullable(wrapped.getSparrowNBTComponent(ComponentTypes.CUSTOM_DATA)).map(CompoundTag.class::cast).orElse(new CompoundTag());
        CompoundTag arguments = customData.getCompound("craftengine:arguments");
        if (arguments == null) {
            context = ItemBuildContext.of(player);
        } else {
            ContextHolder.Builder builder = ContextHolder.builder();
            for (Map.Entry entry : arguments.entrySet()) {
                builder.withParameter(ContextKey.direct((String)entry.getKey()), ((Tag)entry.getValue()).getAsString());
            }
            context = ItemBuildContext.of(player, builder);
        }
        CompoundTag tag = new CompoundTag();
        for (ItemDataModifier<ItemStack> itemDataModifier : customItem.clientBoundDataModifiers()) {
            itemDataModifier.prepareNetworkItem(original, context, tag);
        }
        for (ItemDataModifier<ItemStack> itemDataModifier : customItem.clientBoundDataModifiers()) {
            itemDataModifier.apply(wrapped, context);
        }
        if (Config.interceptItem()) {
            if (!tag.containsKey("minecraft:item_name")) {
                if (VersionHelper.isOrAbove1_21_5()) {
                    ModernNetworkItemHandler.processModernItemName(wrapped, () -> tag);
                } else {
                    ModernNetworkItemHandler.processLegacyItemName(wrapped, () -> tag);
                }
            }
            if (!tag.containsKey("minecraft:custom_name")) {
                if (VersionHelper.isOrAbove1_21_5()) {
                    ModernNetworkItemHandler.processModernCustomName(wrapped, () -> tag);
                } else {
                    ModernNetworkItemHandler.processLegacyCustomName(wrapped, () -> tag);
                }
            }
            if (!tag.containsKey("minecraft:lore")) {
                if (VersionHelper.isOrAbove1_21_5()) {
                    ModernNetworkItemHandler.processModernLore(wrapped, () -> tag);
                } else {
                    ModernNetworkItemHandler.processLegacyLore(wrapped, () -> tag);
                }
            }
        }
        if (tag.isEmpty()) {
            if (hasDifferentMaterial) {
                return Optional.of(wrapped);
            }
            return Optional.empty();
        }
        customData.put("craftengine:network_modifiers", tag);
        wrapped.setNBTComponent(ComponentTypes.CUSTOM_DATA, customData);
        return Optional.of(wrapped);
    }

    public static boolean processLegacyLore(Item<ItemStack> item, Supplier<CompoundTag> tag) {
        Optional<List<String>> optionalLore = item.loreJson();
        if (optionalLore.isPresent()) {
            boolean changed = false;
            List<String> lore = optionalLore.get();
            ArrayList<String> newLore = new ArrayList<String>(lore.size());
            for (String line : lore) {
                Map<String, Component> tokens = CraftEngine.instance().fontManager().matchTags(line);
                if (tokens.isEmpty()) {
                    newLore.add(line);
                    continue;
                }
                newLore.add(AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(line), tokens)));
                changed = true;
            }
            if (changed) {
                item.loreJson(newLore);
                ListTag listTag = new ListTag();
                for (String line : lore) {
                    listTag.add(new StringTag(line));
                }
                tag.get().put("minecraft:lore", NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, listTag));
                return true;
            }
        }
        return false;
    }

    public static boolean processLegacyCustomName(Item<ItemStack> item, Supplier<CompoundTag> tag) {
        Optional<String> optionalCustomName = item.customNameJson();
        if (optionalCustomName.isPresent()) {
            String line = optionalCustomName.get();
            Map<String, Component> tokens = CraftEngine.instance().fontManager().matchTags(line);
            if (!tokens.isEmpty()) {
                item.customNameJson(AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(line), tokens)));
                tag.get().put("minecraft:custom_name", NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, new StringTag(line)));
                return true;
            }
        }
        return false;
    }

    public static boolean processLegacyItemName(Item<ItemStack> item, Supplier<CompoundTag> tag) {
        Optional<String> optionalItemName = item.itemNameJson();
        if (optionalItemName.isPresent()) {
            String line = optionalItemName.get();
            Map<String, Component> tokens = CraftEngine.instance().fontManager().matchTags(line);
            if (!tokens.isEmpty()) {
                item.itemNameJson(AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(line), tokens)));
                tag.get().put("minecraft:item_name", NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, new StringTag(line)));
                return true;
            }
        }
        return false;
    }

    public static boolean processModernItemName(Item<ItemStack> item, Supplier<CompoundTag> tag) {
        Tag nameTag = item.getSparrowNBTComponent(ComponentTypes.ITEM_NAME);
        if (nameTag == null) {
            return false;
        }
        String tagStr = nameTag.getAsString();
        Map<String, Component> tokens = CraftEngine.instance().fontManager().matchTags(tagStr);
        if (!tokens.isEmpty()) {
            item.setNBTComponent(ComponentKeys.ITEM_NAME, AdventureHelper.componentToNbt(AdventureHelper.replaceText(AdventureHelper.nbtToComponent(nameTag), tokens)));
            tag.get().put("minecraft:item_name", NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, nameTag));
            return true;
        }
        return false;
    }

    public static boolean processModernCustomName(Item<ItemStack> item, Supplier<CompoundTag> tag) {
        Tag nameTag = item.getSparrowNBTComponent(ComponentTypes.CUSTOM_NAME);
        if (nameTag == null) {
            return false;
        }
        String tagStr = nameTag.getAsString();
        Map<String, Component> tokens = CraftEngine.instance().fontManager().matchTags(tagStr);
        if (!tokens.isEmpty()) {
            item.setNBTComponent(ComponentKeys.CUSTOM_NAME, AdventureHelper.componentToNbt(AdventureHelper.replaceText(AdventureHelper.nbtToComponent(nameTag), tokens)));
            tag.get().put("minecraft:custom_name", NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, nameTag));
            return true;
        }
        return false;
    }

    public static boolean processModernLore(Item<ItemStack> item, Supplier<CompoundTag> tagSupplier) {
        Tag loreTag = item.getSparrowNBTComponent(ComponentTypes.LORE);
        boolean changed = false;
        if (!(loreTag instanceof ListTag)) {
            return false;
        }
        ListTag listTag = (ListTag)loreTag;
        ListTag newLore = new ListTag();
        for (Tag tag : listTag) {
            String tagStr = tag.getAsString();
            Map<String, Component> tokens = CraftEngine.instance().fontManager().matchTags(tagStr);
            if (tokens.isEmpty()) {
                newLore.add(tag);
                continue;
            }
            newLore.add(AdventureHelper.componentToNbt(AdventureHelper.replaceText(AdventureHelper.nbtToComponent(tag), tokens)));
            changed = true;
        }
        if (changed) {
            item.setNBTComponent(ComponentKeys.LORE, newLore);
            tagSupplier.get().put("minecraft:lore", NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, listTag));
            return true;
        }
        return false;
    }

    static class OtherItem {
        private final Item<ItemStack> item;
        private final boolean forceReturn;
        private boolean globalChanged = false;
        private CompoundTag tag;

        public OtherItem(Item<ItemStack> item, boolean forceReturn) {
            this.item = item;
            this.forceReturn = forceReturn;
        }

        public Optional<Item<ItemStack>> process() {
            if (VersionHelper.isOrAbove1_21_5()) {
                if (ModernNetworkItemHandler.processModernLore(this.item, this::getOrCreateTag)) {
                    this.globalChanged = true;
                }
                if (ModernNetworkItemHandler.processModernCustomName(this.item, this::getOrCreateTag)) {
                    this.globalChanged = true;
                }
                if (ModernNetworkItemHandler.processModernItemName(this.item, this::getOrCreateTag)) {
                    this.globalChanged = true;
                }
            } else {
                if (ModernNetworkItemHandler.processLegacyLore(this.item, this::getOrCreateTag)) {
                    this.globalChanged = true;
                }
                if (ModernNetworkItemHandler.processLegacyCustomName(this.item, this::getOrCreateTag)) {
                    this.globalChanged = true;
                }
                if (ModernNetworkItemHandler.processLegacyItemName(this.item, this::getOrCreateTag)) {
                    this.globalChanged = true;
                }
            }
            if (this.globalChanged) {
                CompoundTag customData = Optional.ofNullable(this.item.getSparrowNBTComponent(ComponentTypes.CUSTOM_DATA)).map(CompoundTag.class::cast).orElse(new CompoundTag());
                customData.put("craftengine:network_modifiers", this.getOrCreateTag());
                this.item.setNBTComponent(ComponentKeys.CUSTOM_DATA, customData);
                return Optional.of(this.item);
            }
            if (this.forceReturn) {
                return Optional.of(this.item);
            }
            return Optional.empty();
        }

        private CompoundTag getOrCreateTag() {
            if (this.tag == null) {
                this.tag = new CompoundTag();
            }
            return this.tag;
        }
    }
}

