/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item.behavior;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.block.behavior.StrippableBlockBehavior;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.EventUtils;
import net.momirealms.craftengine.bukkit.util.InteractUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.bukkit.util.MaterialUtils;
import net.momirealms.craftengine.bukkit.world.BukkitBlockInWorld;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.UpdateOption;
import net.momirealms.craftengine.core.entity.player.InteractionHand;
import net.momirealms.craftengine.core.entity.player.InteractionResult;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.behavior.ItemBehaviorFactory;
import net.momirealms.craftengine.core.item.context.UseOnContext;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.util.ItemUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.Vec3d;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import org.bukkit.GameEvent;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class AxeItemBehavior
extends ItemBehavior {
    public static final Factory FACTORY = new Factory();
    public static final AxeItemBehavior INSTANCE = new AxeItemBehavior();
    private static final Key AXE_STRIP_SOUND = Key.of("minecraft:item.axe.strip");

    private boolean canBlockAttack(Item<ItemStack> item) {
        if (VersionHelper.isOrAbove1_21_5()) {
            return item.hasComponent("minecraft:blocks_attacks");
        }
        return item.vanillaId().equals(ItemKeys.SHIELD);
    }

    @Override
    public InteractionResult useOnBlock(UseOnContext context) {
        EntityChangeBlockEvent event;
        Item<ItemStack> offHandItem;
        Player player = context.getPlayer();
        if (player != null && player.isAdventureMode()) {
            return InteractionResult.PASS;
        }
        Object blockState = FastNMS.INSTANCE.method$BlockGetter$getBlockState(context.getLevel().serverWorld(), LocationUtils.toBlockPos(context.getClickedPos()));
        Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(blockState);
        if (optionalCustomState.isEmpty()) {
            return InteractionResult.PASS;
        }
        ImmutableBlockState customState = optionalCustomState.get();
        Optional<StrippableBlockBehavior> behaviorOptional = customState.behavior().getAs(StrippableBlockBehavior.class);
        if (behaviorOptional.isEmpty()) {
            return InteractionResult.PASS;
        }
        Key stripped = behaviorOptional.get().stripped();
        Item<Object> item = offHandItem = player != null ? player.getItemInHand(InteractionHand.OFF_HAND) : BukkitItemManager.instance().uniqueEmptyItem().item();
        if (context.getHand() == InteractionHand.MAIN_HAND && !ItemUtils.isEmpty(offHandItem) && this.canBlockAttack(offHandItem) && player != null && !player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        Optional<CustomBlock> optionalNewCustomBlock = BukkitBlockManager.instance().blockById(stripped);
        if (optionalNewCustomBlock.isEmpty()) {
            CraftEngine.instance().logger().warn("stripped block " + String.valueOf(stripped) + " does not exist");
            return InteractionResult.FAIL;
        }
        CustomBlock newCustomBlock = optionalNewCustomBlock.get();
        CompoundTag compoundTag = customState.propertiesNbt();
        ImmutableBlockState newState = newCustomBlock.getBlockState(compoundTag);
        BukkitBlockInWorld clicked = (BukkitBlockInWorld)context.getLevel().getBlockAt(context.getClickedPos());
        org.bukkit.entity.Player bukkitPlayer = null;
        if (player != null && EventUtils.fireAndCheckCancel((Event)(event = new EntityChangeBlockEvent((Entity)(bukkitPlayer = (org.bukkit.entity.Player)player.platformPlayer()), clicked.block(), BlockStateUtils.fromBlockData(newState.customBlockState().handle()))))) {
            return InteractionResult.FAIL;
        }
        Item<ItemStack> item2 = context.getItem();
        if (ItemUtils.isEmpty(item2)) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.getClickedPos();
        context.getLevel().playBlockSound(Vec3d.atCenterOf(pos), AXE_STRIP_SOUND, 1.0f, 1.0f);
        FastNMS.INSTANCE.method$LevelWriter$setBlock(context.getLevel().serverWorld(), LocationUtils.toBlockPos(pos), newState.customBlockState().handle(), UpdateOption.UPDATE_ALL_IMMEDIATE.flags());
        clicked.block().getWorld().sendGameEvent((Entity)bukkitPlayer, GameEvent.BLOCK_CHANGE, new Vector(pos.x(), pos.y(), pos.z()));
        Material material = MaterialUtils.getMaterial(item2.vanillaId());
        if (bukkitPlayer != null) {
            bukkitPlayer.setStatistic(Statistic.USE_ITEM, material, bukkitPlayer.getStatistic(Statistic.USE_ITEM, material) + 1);
            if (!InteractUtils.isInteractable(bukkitPlayer, BlockStateUtils.fromBlockData(customState.vanillaBlockState().handle()), context.getHitResult(), item2) || player.isSecondaryUseActive()) {
                player.swingHand(context.getHand());
            }
            if (VersionHelper.isOrAbove1_20_5()) {
                Object itemStack = item2.getLiteralObject();
                Object serverPlayer = player.serverPlayer();
                Object equipmentSlot = context.getHand() == InteractionHand.MAIN_HAND ? CoreReflections.instance$EquipmentSlot$MAINHAND : CoreReflections.instance$EquipmentSlot$OFFHAND;
                try {
                    CoreReflections.method$ItemStack$hurtAndBreak.invoke(itemStack, 1, serverPlayer, equipmentSlot);
                }
                catch (ReflectiveOperationException e) {
                    CraftEngine.instance().logger().warn("Failed to hurt itemStack", e);
                }
            } else {
                ItemStack itemStack = item2.getItem();
                itemStack.damage(1, (LivingEntity)bukkitPlayer);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static class Factory
    implements ItemBehaviorFactory {
        @Override
        public ItemBehavior create(Pack pack, Path path, Key key, Map<String, Object> arguments) {
            return INSTANCE;
        }
    }
}

