/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item.behavior;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.api.CraftEngineBlocks;
import net.momirealms.craftengine.bukkit.api.event.CustomBlockAttemptPlaceEvent;
import net.momirealms.craftengine.bukkit.api.event.CustomBlockPlaceEvent;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.util.AdventureModeUtils;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.DirectionUtils;
import net.momirealms.craftengine.bukkit.util.EventUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.bukkit.world.BukkitBlockInWorld;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.UpdateOption;
import net.momirealms.craftengine.core.entity.player.InteractionHand;
import net.momirealms.craftengine.core.entity.player.InteractionResult;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.behavior.BlockBoundItemBehavior;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.behavior.ItemBehaviorFactory;
import net.momirealms.craftengine.core.item.context.BlockPlaceContext;
import net.momirealms.craftengine.core.item.context.UseOnContext;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Cancellable;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.WorldPosition;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.ComponentLike;
import net.momirealms.craftengine.libraries.adventure.text.format.NamedTextColor;
import net.momirealms.craftengine.libraries.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.GameEvent;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class BlockItemBehavior
extends BlockBoundItemBehavior {
    public static final Factory FACTORY = new Factory();
    private final Key blockId;

    public BlockItemBehavior(Key blockId) {
        this.blockId = blockId;
    }

    @Override
    public InteractionResult useOnBlock(UseOnContext context) {
        return this.place(new BlockPlaceContext(context));
    }

    public InteractionResult place(BlockPlaceContext context) {
        org.bukkit.entity.Player bukkitPlayer;
        Optional<CustomBlock> optionalBlock = BukkitBlockManager.instance().blockById(this.blockId);
        if (optionalBlock.isEmpty()) {
            CraftEngine.instance().logger().warn("Failed to place unknown block " + String.valueOf(this.blockId));
            return InteractionResult.FAIL;
        }
        if (!context.canPlace()) {
            return InteractionResult.FAIL;
        }
        Player player = context.getPlayer();
        CustomBlock block = optionalBlock.get();
        BlockPos pos = context.getClickedPos();
        int maxY = context.getLevel().worldHeight().getMaxBuildHeight() - 1;
        if (context.getClickedFace() == Direction.UP && pos.y() >= maxY) {
            if (player != null) {
                player.sendActionBar(Component.translatable((String)"build.tooHigh").arguments(new ComponentLike[]{Component.text((int)maxY)}).color((TextColor)NamedTextColor.RED));
            }
            return InteractionResult.FAIL;
        }
        ImmutableBlockState blockStateToPlace = this.getPlacementState(context, block);
        if (blockStateToPlace == null) {
            return InteractionResult.FAIL;
        }
        BlockPos againstPos = context.getAgainstPos();
        World world = (World)context.getLevel().platformWorld();
        Location placeLocation = new Location(world, (double)pos.x(), (double)pos.y(), (double)pos.z());
        Block bukkitBlock = world.getBlockAt(placeLocation);
        Block againstBlock = world.getBlockAt(againstPos.x(), againstPos.y(), againstPos.z());
        org.bukkit.entity.Player player2 = bukkitPlayer = player != null ? (org.bukkit.entity.Player)player.platformPlayer() : null;
        if (player != null) {
            CustomBlockAttemptPlaceEvent attemptPlaceEvent;
            if (player.isAdventureMode()) {
                Object againstBlockState = BlockStateUtils.blockDataToBlockState(againstBlock.getBlockData());
                Optional<ImmutableBlockState> optionalCustomState = BlockStateUtils.getOptionalCustomBlockState(againstBlockState);
                if (optionalCustomState.isEmpty()) {
                    if (!AdventureModeUtils.canPlace(context.getItem(), context.getLevel(), againstPos, againstBlockState)) {
                        return InteractionResult.FAIL;
                    }
                } else {
                    ImmutableBlockState customState = optionalCustomState.get();
                    if (!AdventureModeUtils.canPlace(context.getItem(), context.getLevel(), againstPos, Config.simplifyAdventurePlaceCheck() ? customState.vanillaBlockState().handle() : againstBlockState)) {
                        return InteractionResult.FAIL;
                    }
                }
            }
            if (EventUtils.fireAndCheckCancel((Event)(attemptPlaceEvent = new CustomBlockAttemptPlaceEvent(bukkitPlayer, placeLocation.clone(), blockStateToPlace, DirectionUtils.toBlockFace(context.getClickedFace()), bukkitBlock, context.getHand())))) {
                return InteractionResult.FAIL;
            }
        }
        BlockState previousState = bukkitBlock.getState();
        ArrayList<BlockState> revertStates = new ArrayList<BlockState>(2);
        revertStates.add(previousState);
        this.placeBlock(placeLocation, blockStateToPlace, revertStates);
        if (player != null) {
            BlockPlaceEvent bukkitPlaceEvent = new BlockPlaceEvent(bukkitBlock, previousState, againstBlock, (ItemStack)context.getItem().getItem(), bukkitPlayer, true, context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
            if (EventUtils.fireAndCheckCancel((Event)bukkitPlaceEvent)) {
                for (BlockState state : revertStates) {
                    state.update(true, false);
                }
                return InteractionResult.FAIL;
            }
            CustomBlockPlaceEvent customPlaceEvent = new CustomBlockPlaceEvent(bukkitPlayer, placeLocation.clone(), blockStateToPlace, world.getBlockAt(placeLocation), context.getHand());
            if (EventUtils.fireAndCheckCancel((Event)customPlaceEvent)) {
                for (BlockState state : revertStates) {
                    state.update(true, false);
                }
                return InteractionResult.FAIL;
            }
        }
        WorldPosition position = new WorldPosition(context.getLevel(), (double)pos.x() + 0.5, (double)pos.y() + 0.5, (double)pos.z() + 0.5);
        Cancellable dummy = Cancellable.dummy();
        PlayerOptionalContext functionContext = PlayerOptionalContext.of(player, ContextHolder.builder().withParameter(DirectContextParameters.BLOCK, new BukkitBlockInWorld(bukkitBlock)).withParameter(DirectContextParameters.POSITION, position).withParameter(DirectContextParameters.EVENT, dummy).withParameter(DirectContextParameters.HAND, context.getHand()).withParameter(DirectContextParameters.ITEM_IN_HAND, context.getItem()));
        block.execute(functionContext, EventTrigger.PLACE);
        if (dummy.isCancelled()) {
            return InteractionResult.SUCCESS_AND_CANCEL;
        }
        if (player != null) {
            if (!player.isCreativeMode()) {
                Item<?> item = context.getItem();
                item.count(item.count() - 1);
            }
            player.swingHand(context.getHand());
        }
        block.setPlacedBy(context, blockStateToPlace);
        context.getLevel().playBlockSound(position, blockStateToPlace.settings().sounds().placeSound());
        world.sendGameEvent((Entity)bukkitPlayer, GameEvent.BLOCK_PLACE, new Vector(pos.x(), pos.y(), pos.z()));
        return InteractionResult.SUCCESS;
    }

    protected ImmutableBlockState getPlacementState(BlockPlaceContext context, CustomBlock block) {
        ImmutableBlockState state = block.getStateForPlacement(context);
        return state != null && this.canPlace(context, state) ? state : null;
    }

    protected boolean checkStatePlacement() {
        return true;
    }

    protected boolean canPlace(BlockPlaceContext context, ImmutableBlockState state) {
        try {
            Player cePlayer = context.getPlayer();
            Object player = cePlayer != null ? cePlayer.serverPlayer() : null;
            Object blockState = state.customBlockState().handle();
            Object blockPos = LocationUtils.toBlockPos(context.getClickedPos());
            Object voxelShape = VersionHelper.isOrAbove1_21_6() ? CoreReflections.method$CollisionContext$placementContext.invoke(null, player) : (player != null ? CoreReflections.method$CollisionContext$of.invoke(null, player) : CoreReflections.instance$CollisionContext$empty);
            Object world = FastNMS.INSTANCE.field$CraftWorld$ServerLevel((World)context.getLevel().platformWorld());
            boolean defaultReturn = (!this.checkStatePlacement() || FastNMS.INSTANCE.method$BlockStateBase$canSurvive(blockState, world, blockPos)) && (Boolean)CoreReflections.method$ServerLevel$checkEntityCollision.invoke(world, blockState, player, voxelShape, blockPos, true) != false;
            Block block = FastNMS.INSTANCE.method$CraftBlock$at(world, blockPos);
            BlockData blockData = FastNMS.INSTANCE.method$CraftBlockData$fromData(blockState);
            BlockCanBuildEvent canBuildEvent = new BlockCanBuildEvent(block, cePlayer != null ? (org.bukkit.entity.Player)cePlayer.platformPlayer() : null, blockData, defaultReturn, context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
            Bukkit.getPluginManager().callEvent((Event)canBuildEvent);
            return canBuildEvent.isBuildable();
        }
        catch (ReflectiveOperationException e) {
            CraftEngine.instance().logger().warn("Failed to check canPlace", e);
            return false;
        }
    }

    protected boolean placeBlock(Location location, ImmutableBlockState blockState, List<BlockState> revertStates) {
        return CraftEngineBlocks.place(location, blockState, UpdateOption.UPDATE_ALL_IMMEDIATE, false);
    }

    @Override
    public Key block() {
        return this.blockId;
    }

    public static class Factory
    implements ItemBehaviorFactory {
        @Override
        public ItemBehavior create(Pack pack, Path path, Key key, Map<String, Object> arguments) {
            Object id = arguments.get("block");
            if (id == null) {
                throw new LocalizedResourceConfigException("warning.config.item.behavior.block.missing_block", new IllegalArgumentException("Missing required parameter 'block' for block_item behavior"), new String[0]);
            }
            if (id instanceof Map) {
                Map map = (Map)id;
                if (map.containsKey(key.toString())) {
                    BukkitBlockManager.instance().parser().parseSection(pack, path, key, MiscUtils.castToMap(map.get(key.toString()), false));
                } else {
                    BukkitBlockManager.instance().parser().parseSection(pack, path, key, MiscUtils.castToMap(map, false));
                }
                return new BlockItemBehavior(key);
            }
            return new BlockItemBehavior(Key.of(id.toString()));
        }
    }
}

