/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item.listener;

import java.util.Map;
import net.momirealms.craftengine.bukkit.api.CraftEngineItems;
import net.momirealms.craftengine.bukkit.util.ItemStackUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ArmorEventListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onInteractHorse(PlayerInteractEntityEvent event) {
        if (VersionHelper.isOrAbove1_21_2()) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            ItemStack itemInHand = event.getPlayer().getInventory().getItem(event.getHand());
            if (horse.getInventory().getArmor() == null) {
                switch (itemInHand.getType()) {
                    case LEATHER_HORSE_ARMOR: 
                    case IRON_HORSE_ARMOR: 
                    case GOLDEN_HORSE_ARMOR: 
                    case DIAMOND_HORSE_ARMOR: {
                        if (!CraftEngineItems.isCustomItem(itemInHand)) break;
                        event.setCancelled(true);
                    }
                }
            } else if (horse.getInventory().getSaddle() == null && itemInHand.getType() == Material.SADDLE && CraftEngineItems.isCustomItem(itemInHand)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onMoveItemInHorseInventory(InventoryClickEvent event) {
        if (VersionHelper.isOrAbove1_21_2()) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof HorseInventory)) {
            return;
        }
        HorseInventory horseInventory = (HorseInventory)inventory;
        if (event.getClickedInventory() == event.getWhoClicked().getInventory()) {
            ItemStack currentItem = event.getCurrentItem();
            if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && currentItem != null && CraftEngineItems.isCustomItem(currentItem)) {
                event.setCancelled(true);
            }
        } else if (event.getClickedInventory() == horseInventory) {
            ItemStack itemInCursor = event.getCursor();
            if ((event.getAction() == InventoryAction.SWAP_WITH_CURSOR || event.getAction() == InventoryAction.PLACE_ALL || event.getAction() == InventoryAction.PLACE_ONE) && !ItemStackUtils.isEmpty(itemInCursor) && CraftEngineItems.isCustomItem(itemInCursor)) {
                event.setCancelled(true);
                return;
            }
            if (event.getAction() == InventoryAction.HOTBAR_SWAP) {
                int slot = event.getHotbarButton();
                if (slot != -1) {
                    ItemStack itemInHotBar = event.getWhoClicked().getInventory().getItem(slot);
                    if (!ItemStackUtils.isEmpty(itemInHotBar) && CraftEngineItems.isCustomItem(itemInHotBar)) {
                        event.setCancelled(true);
                        return;
                    }
                } else {
                    ItemStack offHand = event.getWhoClicked().getInventory().getItemInOffHand();
                    if (!ItemStackUtils.isEmpty(offHand) && CraftEngineItems.isCustomItem(offHand)) {
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onMoveItemInHorseInventory(InventoryDragEvent event) {
        if (VersionHelper.isOrAbove1_21_2()) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof HorseInventory)) {
            return;
        }
        HorseInventory horseInventory = (HorseInventory)inventory;
        for (Map.Entry entry : event.getNewItems().entrySet()) {
            if ((Integer)entry.getKey() != 0 && (Integer)entry.getKey() != 1 || ItemStackUtils.isEmpty((ItemStack)entry.getValue()) || !CraftEngineItems.isCustomItem((ItemStack)entry.getValue())) continue;
            event.setCancelled(true);
            return;
        }
    }
}

