/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item.recipe;

import com.destroystokyo.paper.event.inventory.PrepareResultEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.item.ComponentTypes;
import net.momirealms.craftengine.bukkit.item.recipe.BukkitRecipeManager;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.reflection.bukkit.CraftBukkitReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.ComponentUtils;
import net.momirealms.craftengine.bukkit.util.InventoryUtils;
import net.momirealms.craftengine.bukkit.util.ItemStackUtils;
import net.momirealms.craftengine.bukkit.util.LegacyInventoryUtils;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.ItemManager;
import net.momirealms.craftengine.core.item.equipment.TrimBasedEquipment;
import net.momirealms.craftengine.core.item.recipe.CustomCraftingTableRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmithingTransformRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmithingTrimRecipe;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeType;
import net.momirealms.craftengine.core.item.recipe.input.CraftingInput;
import net.momirealms.craftengine.core.item.recipe.input.SingleItemInput;
import net.momirealms.craftengine.core.item.recipe.input.SmithingInput;
import net.momirealms.craftengine.core.item.setting.AnvilRepairItem;
import net.momirealms.craftengine.core.item.setting.ItemEquipment;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.Pair;
import net.momirealms.craftengine.core.util.Tristate;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.CartographyInventory;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.view.AnvilView;

public class RecipeEventListener
implements Listener {
    private final ItemManager<ItemStack> itemManager;
    private final BukkitRecipeManager recipeManager;
    private final BukkitCraftEngine plugin;

    public RecipeEventListener(BukkitCraftEngine plugin, BukkitRecipeManager recipeManager, ItemManager<ItemStack> itemManager) {
        this.itemManager = itemManager;
        this.recipeManager = recipeManager;
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onClickInventoryWithFuel(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof FurnaceInventory)) {
            return;
        }
        FurnaceInventory furnaceInventory = (FurnaceInventory)inventory;
        ItemStack fuelStack = furnaceInventory.getFuel();
        Inventory clickedInventory = event.getClickedInventory();
        Player player = (Player)event.getWhoClicked();
        if (clickedInventory == player.getInventory()) {
            if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT) {
                ItemStack item = event.getCurrentItem();
                if (ItemStackUtils.isEmpty(item)) {
                    return;
                }
                if (ItemStackUtils.isEmpty(fuelStack)) {
                    SingleItemInput<ItemStack> input = new SingleItemInput<ItemStack>(ItemStackUtils.getUniqueIdItem(item));
                    RecipeType recipeType = furnaceInventory.getType() == InventoryType.FURNACE ? RecipeType.SMELTING : (furnaceInventory.getType() == InventoryType.BLAST_FURNACE ? RecipeType.BLASTING : RecipeType.SMOKING);
                    Recipe ceRecipe = this.recipeManager.recipeByInput(recipeType, input);
                    if (ceRecipe != null) {
                        return;
                    }
                    int fuelTime = this.itemManager.fuelTime(item);
                    if (fuelTime == 0) {
                        if (ItemStackUtils.isCustomItem(item) && item.getType().isFuel()) {
                            event.setCancelled(true);
                            ItemStack smelting = furnaceInventory.getSmelting();
                            if (ItemStackUtils.isEmpty(smelting)) {
                                furnaceInventory.setSmelting(item.clone());
                                item.setAmount(0);
                            } else if (smelting.isSimilar(item)) {
                                int maxStackSize = smelting.getMaxStackSize();
                                int canGiveMaxCount = item.getAmount();
                                if (maxStackSize > smelting.getAmount()) {
                                    if (canGiveMaxCount + smelting.getAmount() >= maxStackSize) {
                                        int givenCount = maxStackSize - smelting.getAmount();
                                        smelting.setAmount(maxStackSize);
                                        item.setAmount(item.getAmount() - givenCount);
                                    } else {
                                        smelting.setAmount(smelting.getAmount() + canGiveMaxCount);
                                        item.setAmount(0);
                                    }
                                }
                            }
                            player.updateInventory();
                        }
                        return;
                    }
                    event.setCancelled(true);
                    furnaceInventory.setFuel(item.clone());
                    item.setAmount(0);
                    player.updateInventory();
                } else if (fuelStack.isSimilar(item)) {
                    event.setCancelled(true);
                    int maxStackSize = fuelStack.getMaxStackSize();
                    int canGiveMaxCount = item.getAmount();
                    if (maxStackSize > fuelStack.getAmount()) {
                        if (canGiveMaxCount + fuelStack.getAmount() >= maxStackSize) {
                            int givenCount = maxStackSize - fuelStack.getAmount();
                            fuelStack.setAmount(maxStackSize);
                            item.setAmount(item.getAmount() - givenCount);
                        } else {
                            fuelStack.setAmount(fuelStack.getAmount() + canGiveMaxCount);
                            item.setAmount(0);
                        }
                        player.updateInventory();
                    }
                }
            }
        } else {
            int slot = event.getSlot();
            if (slot != 1) {
                return;
            }
            ClickType clickType = event.getClick();
            switch (clickType) {
                case SWAP_OFFHAND: 
                case NUMBER_KEY: {
                    int hotBarSlot = event.getHotbarButton();
                    ItemStack item = clickType == ClickType.SWAP_OFFHAND ? player.getInventory().getItemInOffHand() : player.getInventory().getItem(hotBarSlot);
                    if (ItemStackUtils.isEmpty(item)) {
                        return;
                    }
                    int fuelTime = this.plugin.itemManager().fuelTime(item);
                    if (fuelTime == 0) {
                        if (ItemStackUtils.isCustomItem(item) && item.getType().isFuel()) {
                            event.setCancelled(true);
                        }
                        return;
                    }
                    event.setCancelled(true);
                    if (fuelStack == null || fuelStack.getType() == Material.AIR) {
                        furnaceInventory.setFuel(item.clone());
                        item.setAmount(0);
                    } else {
                        if (clickType == ClickType.SWAP_OFFHAND) {
                            player.getInventory().setItemInOffHand(fuelStack);
                        } else {
                            player.getInventory().setItem(hotBarSlot, fuelStack);
                        }
                        furnaceInventory.setFuel(item.clone());
                    }
                    player.updateInventory();
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    ItemStack itemOnCursor = event.getCursor();
                    if (ItemStackUtils.isEmpty(itemOnCursor)) {
                        return;
                    }
                    int fuelTime = this.plugin.itemManager().fuelTime(itemOnCursor);
                    if (fuelTime == 0) {
                        if (ItemStackUtils.isCustomItem(itemOnCursor) && itemOnCursor.getType().isFuel()) {
                            event.setCancelled(true);
                        }
                        return;
                    }
                    event.setCancelled(true);
                    if (fuelStack == null || fuelStack.getType() == Material.AIR) {
                        if (clickType == ClickType.LEFT) {
                            furnaceInventory.setFuel(itemOnCursor.clone());
                            itemOnCursor.setAmount(0);
                            player.updateInventory();
                            break;
                        }
                        ItemStack cloned = itemOnCursor.clone();
                        cloned.setAmount(1);
                        furnaceInventory.setFuel(cloned);
                        itemOnCursor.setAmount(itemOnCursor.getAmount() - 1);
                        player.updateInventory();
                        break;
                    }
                    boolean isSimilar = itemOnCursor.isSimilar(fuelStack);
                    if (clickType == ClickType.LEFT) {
                        if (isSimilar) {
                            int maxStackSize = fuelStack.getMaxStackSize();
                            int canGiveMaxCount = itemOnCursor.getAmount();
                            if (maxStackSize <= fuelStack.getAmount()) break;
                            if (canGiveMaxCount + fuelStack.getAmount() >= maxStackSize) {
                                int givenCount = maxStackSize - fuelStack.getAmount();
                                fuelStack.setAmount(maxStackSize);
                                itemOnCursor.setAmount(itemOnCursor.getAmount() - givenCount);
                            } else {
                                fuelStack.setAmount(fuelStack.getAmount() + canGiveMaxCount);
                                itemOnCursor.setAmount(0);
                            }
                            player.updateInventory();
                            break;
                        }
                        event.setCursor(fuelStack);
                        furnaceInventory.setFuel(itemOnCursor.clone());
                        player.updateInventory();
                        break;
                    }
                    if (isSimilar) {
                        int maxStackSize = fuelStack.getMaxStackSize();
                        if (maxStackSize <= fuelStack.getAmount()) break;
                        fuelStack.setAmount(fuelStack.getAmount() + 1);
                        itemOnCursor.setAmount(itemOnCursor.getAmount() - 1);
                        player.updateInventory();
                        break;
                    }
                    event.setCursor(fuelStack);
                    furnaceInventory.setFuel(itemOnCursor.clone());
                    player.updateInventory();
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onFurnaceBurn(FurnaceBurnEvent event) {
        ItemStack fuel = event.getFuel();
        int fuelTime = this.itemManager.fuelTime(fuel);
        if (fuelTime != 0) {
            event.setBurnTime(fuelTime);
        }
    }

    @EventHandler
    public void onPrepareResult(PrepareResultEvent event) {
        CartographyInventory cartographyInventory;
        Inventory inventory = event.getInventory();
        if (inventory instanceof CartographyInventory && ItemStackUtils.hasCustomItem((cartographyInventory = (CartographyInventory)inventory).getStorageContents())) {
            event.setResult(new ItemStack(Material.AIR));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onAnvilEvent(PrepareAnvilEvent event) {
        this.preProcess(event);
        this.processRepairable(event);
        this.processRename(event);
    }

    private void preProcess(PrepareAnvilEvent event) {
        AnvilInventory inventory = event.getInventory();
        ItemStack first = inventory.getFirstItem();
        ItemStack second = inventory.getSecondItem();
        if (first == null || second == null) {
            return;
        }
        Item<ItemStack> wrappedFirst = BukkitItemManager.instance().wrap(first);
        Optional<CustomItem<ItemStack>> firstCustom = wrappedFirst.getCustomItem();
        Item<ItemStack> wrappedSecond = BukkitItemManager.instance().wrap(second);
        Optional<CustomItem<ItemStack>> secondCustom = wrappedFirst.getCustomItem();
        if (firstCustom.isEmpty() && secondCustom.isEmpty()) {
            return;
        }
        if (wrappedSecond.vanillaId().equals(ItemKeys.ENCHANTED_BOOK)) {
            return;
        }
        if (firstCustom.isPresent() && secondCustom.isEmpty()) {
            if (firstCustom.get().settings().respectRepairableComponent()) {
                if (second.canRepair(first)) {
                    return;
                }
            } else {
                event.setResult(null);
                return;
            }
        }
        if (firstCustom.isEmpty() && secondCustom.isPresent()) {
            if (secondCustom.get().settings().respectRepairableComponent()) {
                if (second.canRepair(first)) {
                    return;
                }
            } else {
                event.setResult(null);
                return;
            }
        }
        if (!wrappedFirst.customId().equals(wrappedSecond.customId())) {
            event.setResult(null);
            return;
        }
        firstCustom.ifPresent(it -> {
            if (it.settings().canRepair() == Tristate.FALSE) {
                event.setResult(null);
            }
        });
    }

    private void processRepairable(PrepareAnvilEvent event) {
        int maxRepairCost;
        String renameText;
        AnvilInventory inventory = event.getInventory();
        ItemStack first = inventory.getFirstItem();
        ItemStack second = inventory.getSecondItem();
        if (ItemStackUtils.isEmpty(first) || ItemStackUtils.isEmpty(second)) {
            return;
        }
        Item<ItemStack> wrappedSecond = BukkitItemManager.instance().wrap(second);
        Optional<CustomItem<ItemStack>> customItemOptional = this.plugin.itemManager().getCustomItem(wrappedSecond.id());
        if (customItemOptional.isEmpty()) {
            return;
        }
        CustomItem<ItemStack> customItem = customItemOptional.get();
        List<AnvilRepairItem> repairItems = customItem.settings().repairItems();
        if (repairItems.isEmpty()) {
            return;
        }
        Item<ItemStack> wrappedFirst = BukkitItemManager.instance().wrap(first.clone());
        int maxDamage = wrappedFirst.maxDamage();
        int damage = wrappedFirst.damage().orElse(0);
        if (damage == 0 || maxDamage == 0) {
            return;
        }
        Key firstId = wrappedFirst.id();
        Optional<CustomItem<ItemStack>> optionalCustomTool = wrappedFirst.getCustomItem();
        if (optionalCustomTool.isPresent() && optionalCustomTool.get().settings().canRepair() == Tristate.FALSE) {
            return;
        }
        AnvilRepairItem repairItem = null;
        block4: for (AnvilRepairItem item : repairItems) {
            for (String target : item.targets()) {
                if (target.charAt(0) == '#') {
                    Key tag = Key.of(target.substring(1));
                    if (optionalCustomTool.isPresent() && optionalCustomTool.get().is(tag)) {
                        repairItem = item;
                        continue block4;
                    }
                    if (!wrappedFirst.hasItemTag(tag)) continue;
                    repairItem = item;
                    continue block4;
                }
                if (!target.equals(firstId.toString())) continue;
                repairItem = item;
                continue block4;
            }
        }
        if (repairItem == null) {
            return;
        }
        boolean hasResult = true;
        int realDurabilityPerItem = (int)((double)repairItem.amount() + repairItem.percent() * (double)maxDamage);
        int consumeMaxAmount = damage / realDurabilityPerItem + 1;
        int actualConsumedAmount = Math.min(consumeMaxAmount, wrappedSecond.count());
        int actualRepairAmount = actualConsumedAmount * realDurabilityPerItem;
        int damageAfter = Math.max(damage - actualRepairAmount, 0);
        wrappedFirst.damage(damageAfter);
        if (VersionHelper.isOrAbove1_21()) {
            AnvilView anvilView = event.getView();
            renameText = anvilView.getRenameText();
            maxRepairCost = anvilView.getMaximumRepairCost();
        } else {
            renameText = LegacyInventoryUtils.getRenameText(inventory);
            maxRepairCost = LegacyInventoryUtils.getMaxRepairCost(inventory);
        }
        int repairCost = actualConsumedAmount;
        int repairPenalty = wrappedFirst.repairCost().orElse(0) + wrappedSecond.repairCost().orElse(0);
        if (renameText != null && !renameText.isBlank()) {
            try {
                if (!renameText.equals(CoreReflections.method$Component$getString.invoke(ComponentUtils.jsonToMinecraft(wrappedFirst.hoverNameJson().orElse(AdventureHelper.EMPTY_COMPONENT)), new Object[0]))) {
                    wrappedFirst.customNameJson(AdventureHelper.componentToJson((Component)Component.text((String)renameText)));
                    ++repairCost;
                } else if (repairCost == 0) {
                    hasResult = false;
                }
            }
            catch (ReflectiveOperationException e) {
                this.plugin.logger().warn("Failed to get hover name", e);
            }
        } else if (VersionHelper.isOrAbove1_20_5() && wrappedFirst.hasComponent(ComponentTypes.CUSTOM_NAME)) {
            ++repairCost;
            wrappedFirst.customNameJson(null);
        } else if (!VersionHelper.isOrAbove1_20_5() && wrappedFirst.hasTag("display", "Name")) {
            ++repairCost;
            wrappedFirst.customNameJson(null);
        }
        int finalCost = repairCost + repairPenalty;
        try {
            Object anvilMenu = VersionHelper.isOrAbove1_21() ? CraftBukkitReflections.field$CraftInventoryView$container.get(event.getView()) : CraftBukkitReflections.field$CraftInventoryAnvil$menu.get(inventory);
            CoreReflections.method$AbstractContainerMenu$broadcastFullState.invoke(anvilMenu, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to broadcast changes", e);
        }
        if (VersionHelper.isOrAbove1_21()) {
            AnvilView anvilView = event.getView();
            anvilView.setRepairCost(finalCost);
            anvilView.setRepairItemCountCost(actualConsumedAmount);
        } else {
            LegacyInventoryUtils.setRepairCost(inventory, finalCost);
            LegacyInventoryUtils.setRepairCostAmount(inventory, actualConsumedAmount);
        }
        Player player = InventoryUtils.getPlayerFromInventoryEvent((InventoryEvent)event);
        if (finalCost >= maxRepairCost && !this.plugin.adapt(player).canInstabuild()) {
            hasResult = false;
        }
        if (hasResult) {
            int anotherPenalty;
            int afterPenalty = wrappedFirst.repairCost().orElse(0);
            if (afterPenalty < (anotherPenalty = wrappedSecond.repairCost().orElse(0).intValue())) {
                afterPenalty = anotherPenalty;
            }
            afterPenalty = RecipeEventListener.calculateIncreasedRepairCost(afterPenalty);
            wrappedFirst.repairCost(afterPenalty);
            event.setResult(wrappedFirst.getItem());
        }
    }

    private void processRename(PrepareAnvilEvent event) {
        AnvilInventory inventory = event.getInventory();
        ItemStack first = inventory.getFirstItem();
        if (ItemStackUtils.isEmpty(first)) {
            return;
        }
        if (event.getResult() == null) {
            return;
        }
        Item<ItemStack> wrappedFirst = BukkitItemManager.instance().wrap(first);
        wrappedFirst.getCustomItem().ifPresent(item -> {
            if (!item.settings().renameable()) {
                String renameText;
                if (VersionHelper.isOrAbove1_21()) {
                    AnvilView anvilView = event.getView();
                    renameText = anvilView.getRenameText();
                } else {
                    renameText = LegacyInventoryUtils.getRenameText(inventory);
                }
                if (renameText != null && !renameText.isBlank()) {
                    try {
                        if (!renameText.equals(CoreReflections.method$Component$getString.invoke(ComponentUtils.jsonToMinecraft(wrappedFirst.hoverNameJson().orElse(AdventureHelper.EMPTY_COMPONENT)), new Object[0]))) {
                            event.setResult(null);
                        }
                    }
                    catch (Exception e) {
                        this.plugin.logger().warn("Failed to get hover name", e);
                    }
                }
            }
        });
    }

    public static int calculateIncreasedRepairCost(int cost) {
        return (int)Math.min((long)cost * 2L + 1L, Integer.MAX_VALUE);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onSpecialRecipe(PrepareItemCraftEvent event) {
        org.bukkit.inventory.Recipe recipe = event.getRecipe();
        if (!(recipe instanceof ComplexRecipe)) {
            return;
        }
        ComplexRecipe complexRecipe = (ComplexRecipe)recipe;
        CraftingInventory inventory = event.getInventory();
        ItemStack result = inventory.getResult();
        if (ItemStackUtils.isEmpty(result)) {
            return;
        }
        boolean hasCustomItem = ItemStackUtils.hasCustomItem(inventory.getMatrix());
        if (!hasCustomItem) {
            return;
        }
        if (!CraftBukkitReflections.clazz$CraftComplexRecipe.isInstance(complexRecipe)) {
            return;
        }
        try {
            Object mcRecipe = CraftBukkitReflections.field$CraftComplexRecipe$recipe.get(complexRecipe);
            if (CoreReflections.clazz$ArmorDyeRecipe.isInstance(mcRecipe) || CoreReflections.clazz$FireworkStarFadeRecipe.isInstance(mcRecipe)) {
                return;
            }
            if (CoreReflections.clazz$RepairItemRecipe.isInstance(mcRecipe)) {
                Pair<ItemStack, ItemStack> theOnlyTwoItem = this.getTheOnlyTwoItem(inventory.getMatrix());
                if (theOnlyTwoItem == null) {
                    return;
                }
                Item<ItemStack> first = BukkitItemManager.instance().wrap(theOnlyTwoItem.left());
                Item<ItemStack> right = BukkitItemManager.instance().wrap(theOnlyTwoItem.right());
                int max = Math.max(first.maxDamage(), right.maxDamage());
                int durability1 = first.maxDamage() - first.damage().orElse(0);
                int durability2 = right.maxDamage() - right.damage().orElse(0);
                int finalDurability = durability1 + durability2 + max * 5 / 100;
                Optional<CustomItem<ItemStack>> customItemOptional = this.plugin.itemManager().getCustomItem(first.id());
                if (customItemOptional.isEmpty()) {
                    inventory.setResult(null);
                    return;
                }
                Player player = InventoryUtils.getPlayerFromInventoryEvent((InventoryEvent)event);
                Item newItem = customItemOptional.get().buildItem(this.plugin.adapt(player));
                newItem.maxDamage(max);
                newItem.damage(Math.max(max - finalDurability, 0));
                inventory.setResult((ItemStack)newItem.getItem());
                return;
            }
            inventory.setResult(null);
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to handle custom recipe", e);
        }
    }

    private Pair<ItemStack, ItemStack> getTheOnlyTwoItem(ItemStack[] matrix) {
        ItemStack first = null;
        ItemStack second = null;
        for (ItemStack itemStack : matrix) {
            if (itemStack == null) continue;
            if (first == null) {
                first = itemStack;
                continue;
            }
            if (second != null) {
                return null;
            }
            second = itemStack;
        }
        return new Pair<Object, Object>(first, second);
    }

    @EventHandler(ignoreCancelled=true)
    public void onCraftingRecipe(PrepareItemCraftEvent event) {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        org.bukkit.inventory.Recipe recipe = event.getRecipe();
        if (!(recipe instanceof CraftingRecipe)) {
            return;
        }
        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
        Key recipeId = Key.of(craftingRecipe.getKey().namespace(), craftingRecipe.getKey().value());
        Optional optionalRecipe = this.recipeManager.recipeById(recipeId);
        if (optionalRecipe.isEmpty()) {
            return;
        }
        CraftingInventory inventory = event.getInventory();
        Recipe recipe2 = optionalRecipe.get();
        if (!(recipe2 instanceof CustomCraftingTableRecipe)) {
            inventory.setResult(null);
            return;
        }
        CustomCraftingTableRecipe craftingTableRecipe = (CustomCraftingTableRecipe)recipe2;
        CraftingInput<ItemStack> input = this.getCraftingInput(inventory);
        if (input == null) {
            return;
        }
        Player player = InventoryUtils.getPlayerFromInventoryEvent((InventoryEvent)event);
        BukkitServerPlayer serverPlayer = this.plugin.adapt(player);
        inventory.setResult((ItemStack)craftingTableRecipe.assemble(input, new ItemBuildContext(serverPlayer, ContextHolder.EMPTY)));
    }

    private CraftingInput<ItemStack> getCraftingInput(CraftingInventory inventory) {
        CraftingInput<Object> input;
        ItemStack[] ingredients = inventory.getMatrix();
        ArrayList uniqueIdItems = new ArrayList();
        for (ItemStack itemStack : ingredients) {
            uniqueIdItems.add(ItemStackUtils.getUniqueIdItem(itemStack));
        }
        if (ingredients.length == 9) {
            input = CraftingInput.of(3, 3, uniqueIdItems);
        } else if (ingredients.length == 4) {
            input = CraftingInput.of(2, 2, uniqueIdItems);
        } else {
            return null;
        }
        return input;
    }

    @EventHandler(ignoreCancelled=true)
    public void onSmithingTrim(PrepareSmithingEvent event) {
        CustomItem<ItemStack> customItem;
        Recipe itemEquipmentSettings;
        Item<ItemStack> wrappedEquipment;
        Optional<CustomItem<ItemStack>> optionalCustomItem;
        SmithingInventory inventory = event.getInventory();
        org.bukkit.inventory.Recipe recipe = inventory.getRecipe();
        if (!(recipe instanceof SmithingTrimRecipe)) {
            return;
        }
        SmithingTrimRecipe recipe2 = (SmithingTrimRecipe)recipe;
        ItemStack equipment = inventory.getInputEquipment();
        if (!ItemStackUtils.isEmpty(equipment) && (optionalCustomItem = (wrappedEquipment = this.itemManager.wrap(equipment)).getCustomItem()).isPresent() && (itemEquipmentSettings = (customItem = optionalCustomItem.get()).settings().equipment()) != null && ((ItemEquipment)((Object)itemEquipmentSettings)).equipment() instanceof TrimBasedEquipment) {
            event.setResult(null);
            return;
        }
        Key recipeId = Key.of(recipe2.getKey().namespace(), recipe2.getKey().value());
        Optional optionalRecipe = this.recipeManager.recipeById(recipeId);
        if (optionalRecipe.isEmpty()) {
            return;
        }
        itemEquipmentSettings = optionalRecipe.get();
        if (!(itemEquipmentSettings instanceof CustomSmithingTrimRecipe)) {
            event.setResult(null);
            return;
        }
        CustomSmithingTrimRecipe smithingTrimRecipe = (CustomSmithingTrimRecipe)itemEquipmentSettings;
        SmithingInput<ItemStack> input = this.getSmithingInput(inventory);
        if (smithingTrimRecipe.matches(input)) {
            Player player = InventoryUtils.getPlayerFromInventoryEvent((InventoryEvent)event);
            ItemStack result = (ItemStack)smithingTrimRecipe.assemble(this.getSmithingInput(inventory), new ItemBuildContext(this.plugin.adapt(player), ContextHolder.EMPTY));
            event.setResult(result);
        } else {
            event.setResult(null);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSmithingTransform(PrepareSmithingEvent event) {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        SmithingInventory inventory = event.getInventory();
        org.bukkit.inventory.Recipe recipe = inventory.getRecipe();
        if (!(recipe instanceof SmithingTransformRecipe)) {
            return;
        }
        SmithingTransformRecipe recipe2 = (SmithingTransformRecipe)recipe;
        Key recipeId = Key.of(recipe2.getKey().namespace(), recipe2.getKey().value());
        Optional optionalRecipe = this.recipeManager.recipeById(recipeId);
        if (optionalRecipe.isEmpty()) {
            return;
        }
        Recipe recipe3 = optionalRecipe.get();
        if (!(recipe3 instanceof CustomSmithingTransformRecipe)) {
            event.setResult(null);
            return;
        }
        CustomSmithingTransformRecipe smithingTransformRecipe = (CustomSmithingTransformRecipe)recipe3;
        SmithingInput<ItemStack> input = this.getSmithingInput(inventory);
        if (smithingTransformRecipe.matches(input)) {
            Player player = InventoryUtils.getPlayerFromInventoryEvent((InventoryEvent)event);
            ItemStack processed = (ItemStack)smithingTransformRecipe.assemble(input, new ItemBuildContext(this.plugin.adapt(player), ContextHolder.EMPTY));
            event.setResult(processed);
        } else {
            event.setResult(null);
        }
    }

    private SmithingInput<ItemStack> getSmithingInput(SmithingInventory inventory) {
        return new SmithingInput<ItemStack>(ItemStackUtils.getUniqueIdItem(inventory.getInputEquipment()), ItemStackUtils.getUniqueIdItem(inventory.getInputTemplate()), ItemStackUtils.getUniqueIdItem(inventory.getInputMineral()));
    }
}

