/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.World;
import net.momirealms.craftengine.bukkit.nms.v1_20.recipe.RecipeHelper;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomShapedRecipe;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InjectedShapedRecipe
extends ShapedRecipes {
    private final CustomShapedRecipe<ItemStack> recipe;

    public InjectedShapedRecipe(CustomShapedRecipe<ItemStack> recipe, String group, CraftingBookCategory category, int width, int height, NonNullList<RecipeItemStack> ingredients, net.minecraft.world.item.ItemStack result, boolean showNotification) {
        super(new MinecraftKey(recipe.id().namespace(), recipe.id().value()), group, category, width, height, ingredients, result, showNotification);
        this.recipe = recipe;
    }

    public static InjectedShapedRecipe of(CustomShapedRecipe<ItemStack> recipe) {
        String[] shape = recipe.pattern().pattern();
        int width = shape[0].length();
        NonNullList data = NonNullList.a((int)(shape.length * width), (Object)RecipeItemStack.a);
        for (int i = 0; i < shape.length; ++i) {
            String row = shape[i];
            for (int j = 0; j < row.length(); ++j) {
                data.set(i * width + j, (Object)RecipeHelper.toMinecraft(recipe.pattern().ingredients().get(Character.valueOf(row.charAt(j)))));
            }
        }
        return new InjectedShapedRecipe(recipe, recipe.group(), RecipeHelper.toMinecraft(recipe.category()), width, shape.length, (NonNullList<RecipeItemStack>)data, (net.minecraft.world.item.ItemStack)recipe.result().buildItem(ItemBuildContext.EMPTY).getLiteralObject(), recipe.showNotification());
    }

    public boolean a(@NotNull InventoryCrafting inventory, @NotNull World world) {
        boolean vanillaMatches = super.a(inventory, world);
        if (!vanillaMatches) {
            return false;
        }
        return this.recipe.matches(RecipeHelper.toCraftEngine(inventory));
    }

    @NotNull
    public NonNullList<net.minecraft.world.item.ItemStack> getRemainingItems(@NotNull InventoryCrafting inventory) {
        return RecipeHelper.getRemainingItems(inventory);
    }

    public boolean i() {
        return this.recipe.showNotification();
    }
}

