/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_2.recipe;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CookingRecipeCategory;
import net.momirealms.craftengine.core.item.recipe.CraftingRecipeCategory;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.recipe.input.CraftingInput;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.UniqueKey;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class RecipeHelper {
    public static RecipeItemStack toMinecraft(Ingredient<ItemStack> ingredient) {
        if (ingredient == null) {
            return RecipeItemStack.a;
        }
        ArrayList<net.minecraft.world.item.Item> items = new ArrayList<net.minecraft.world.item.Item>();
        for (UniqueKey uniqueKey : ingredient.minecraftItems()) {
            net.minecraft.world.item.Item item = (net.minecraft.world.item.Item)BuiltInRegistries.i.a(new MinecraftKey(uniqueKey.key().namespace(), uniqueKey.key().value()));
            items.add(item);
        }
        return RecipeItemStack.a((IMaterial[])((IMaterial[])items.toArray(new net.minecraft.world.item.Item[0])));
    }

    public static CraftingInput<ItemStack> toCraftEngine(InventoryCrafting input) {
        return CraftingInput.of(input.f(), input.g(), input.h().stream().map(it -> UniqueIdItem.of(BukkitItemManager.instance().wrap((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)it)))).toList());
    }

    public static CraftingBookCategory toMinecraft(CraftingRecipeCategory category) {
        if (category == null) {
            return null;
        }
        return CraftingBookCategory.values()[category.ordinal()];
    }

    public static CookingBookCategory toMinecraft(CookingRecipeCategory category) {
        if (category == null) {
            return null;
        }
        return CookingBookCategory.values()[category.ordinal()];
    }

    public static net.minecraft.world.item.ItemStack craftingRemainer(net.minecraft.world.item.ItemStack stack) {
        CustomItem<ItemStack> customItem;
        if (stack.b()) {
            return net.minecraft.world.item.ItemStack.b;
        }
        Item<ItemStack> item = BukkitItemManager.instance().wrap((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)stack));
        Optional<CustomItem<ItemStack>> optionalCustomItem = item.getCustomItem();
        if (optionalCustomItem.isPresent() && !(customItem = optionalCustomItem.get()).isVanillaItem()) {
            Optional optionalBuildableItem;
            Key remainder = customItem.settings().craftRemainder();
            if (remainder != null && (optionalBuildableItem = BukkitItemManager.instance().getBuildableItem(remainder)).isPresent()) {
                return (net.minecraft.world.item.ItemStack)optionalBuildableItem.get().buildItem(ItemBuildContext.EMPTY).getLiteralObject();
            }
            return net.minecraft.world.item.ItemStack.b;
        }
        net.minecraft.world.item.Item remainingItem = stack.d().s();
        return remainingItem == null ? net.minecraft.world.item.ItemStack.b : new net.minecraft.world.item.ItemStack((IMaterial)remainingItem);
    }

    @NotNull
    public static NonNullList<net.minecraft.world.item.ItemStack> getRemainingItems(InventoryCrafting input) {
        NonNullList list = NonNullList.a((int)input.b(), (Object)net.minecraft.world.item.ItemStack.b);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)RecipeHelper.craftingRemainer(input.a(i)));
        }
        return list;
    }
}

