/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_3.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.momirealms.craftengine.bukkit.api.BukkitAdaptors;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CraftEngineItem
extends LootSelectorEntry {
    public static final Codec<CraftEngineItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MinecraftKey.a.fieldOf("name").forGetter(entry -> entry.name)).and(CraftEngineItem.b((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, CraftEngineItem::new));
    public static final LootEntryType TYPE = new LootEntryType(CODEC);
    private final MinecraftKey name;

    public CraftEngineItem(MinecraftKey name, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.name = name;
    }

    protected void a(@NotNull Consumer<ItemStack> consumer, @NotNull LootTableInfo lootContext) {
        Optional optionalCustomItem = BukkitItemManager.instance().getCustomItem(KeyUtils.resourceLocationToKey(this.name));
        if (optionalCustomItem.isEmpty()) {
            return;
        }
        BukkitServerPlayer serverPlayer = null;
        Object object = lootContext.b(LootContextParameters.a);
        if (object instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)object;
            serverPlayer = BukkitAdaptors.adapt((Player)player.getBukkitEntity());
        }
        consumer.accept((ItemStack)optionalCustomItem.get().buildItem(serverPlayer).getLiteralObject());
    }

    @NotNull
    public LootEntryType a() {
        return TYPE;
    }
}

