/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_5.recipe;

import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.Level;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.nms.v1_20_5.recipe.RecipeHelper;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomSmokingRecipe;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.recipe.input.SingleItemInput;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InjectedSmokingRecipe
extends SmokingRecipe {
    private final CustomSmokingRecipe<ItemStack> recipe;

    public InjectedSmokingRecipe(CustomSmokingRecipe<ItemStack> recipe, String group, CookingBookCategory category, Ingredient ingredient, net.minecraft.world.item.ItemStack result, float experience, int cookingTime) {
        super(group, category, ingredient, result, experience, cookingTime);
        this.recipe = recipe;
    }

    public static InjectedSmokingRecipe of(CustomSmokingRecipe<ItemStack> recipe) {
        return new InjectedSmokingRecipe(recipe, recipe.group(), RecipeHelper.toMinecraft(recipe.category()), RecipeHelper.toMinecraft(recipe.ingredient()), (net.minecraft.world.item.ItemStack)recipe.result().buildItem(ItemBuildContext.EMPTY).getLiteralObject(), recipe.experience(), recipe.cookingTime());
    }

    public boolean matches(@NotNull Container inventory, @NotNull Level world) {
        boolean vanillaMatches = super.matches(inventory, world);
        if (!vanillaMatches) {
            return false;
        }
        Item<ItemStack> wrapped = BukkitItemManager.instance().wrap((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)inventory.getItem(0)));
        SingleItemInput<ItemStack> singleItemInput = new SingleItemInput<ItemStack>(UniqueIdItem.of(wrapped));
        return this.recipe.matches(singleItemInput);
    }

    public boolean showNotification() {
        return this.recipe.showNotification();
    }
}

