/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_21.collision;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.momirealms.craftengine.bukkit.nms.CollisionEntity;
import org.jetbrains.annotations.NotNull;

public class CollisionBoat
extends Boat
implements CollisionEntity {
    private final AABB aabb;
    private final boolean canProjectileHit;

    public CollisionBoat(EntityType<? extends Boat> type, Level world, double x, double y, double z, AABB aabb, boolean canProjectileHit, boolean blockBuilding) {
        super(type, world);
        this.aabb = aabb;
        this.canProjectileHit = canProjectileHit;
        this.setInvisible(true);
        this.setPos(new Vec3(x, y, z));
        this.setBoundingBox(aabb);
        this.setInvulnerable(true);
        this.setSilent(true);
        this.blocksBuilding = blockBuilding;
        this.landBoats = true;
        this.noPhysics = true;
    }

    public boolean save(@NotNull CompoundTag tag) {
        String s = this.getEncodeId();
        if (s != null) {
            tag.putString("id", s);
            this.saveWithoutId(tag, false);
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        super.remove(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public int getId() {
        return super.getId();
    }

    public void tick() {
    }

    public void setPos(double x, double y, double z) {
        this.setPosRaw(x, y, z, true);
    }

    public boolean canBeHitByProjectile() {
        return this.canProjectileHit;
    }

    public boolean canCollideWith(@NotNull Entity other) {
        return true;
    }

    public boolean canCollideWithBukkit(@NotNull Entity entity) {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public void onAboveBubbleCol(boolean downwards) {
    }

    public void push(@NotNull Entity entity) {
    }

    public void positionRider(@NotNull Entity passenger, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MoveFunction callback) {
    }

    public boolean canAddPassenger(@NotNull Entity passenger) {
        return false;
    }

    public int getMaxPassengers() {
        return 0;
    }

    public boolean isUnderWater() {
        return false;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        return false;
    }

    public void destroy(@NotNull DamageSource source) {
    }

    public void setLeashData(@Nullable Leashable.LeashData leashData) {
    }

    public Leashable.LeashData getLeashData() {
        return null;
    }

    public boolean isPickable() {
        return false;
    }

    public void animateHurt(float yaw) {
    }

    public void setDeltaMovement(@NotNull Vec3 deltaMovement) {
    }

    public void move(@NotNull MoverType type, @NotNull Vec3 movement) {
    }

    @NotNull
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    protected boolean couldAcceptPassenger() {
        return false;
    }

    protected void addPassenger(@NotNull Entity passenger) {
    }
}

