/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_21.recipe;

import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.Level;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.nms.v1_21.recipe.RecipeHelper;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomSmithingTransformRecipe;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.recipe.input.SmithingInput;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InjectedSmithingTransformRecipe
extends SmithingTransformRecipe {
    private final CustomSmithingTransformRecipe<ItemStack> recipe;

    public InjectedSmithingTransformRecipe(CustomSmithingTransformRecipe<ItemStack> recipe, Ingredient template, Ingredient base, Ingredient addition, net.minecraft.world.item.ItemStack result, boolean copyDataComponents) {
        super(template, base, addition, result, copyDataComponents);
        this.recipe = recipe;
    }

    public static InjectedSmithingTransformRecipe of(CustomSmithingTransformRecipe<ItemStack> recipe) {
        net.minecraft.world.item.ItemStack result = (net.minecraft.world.item.ItemStack)recipe.result().buildItem(ItemBuildContext.EMPTY).getLiteralObject();
        return new InjectedSmithingTransformRecipe(recipe, RecipeHelper.toMinecraft(recipe.template()), RecipeHelper.toMinecraft(recipe.base()), RecipeHelper.toMinecraft(recipe.addition()), result, true);
    }

    public boolean matches(@NotNull SmithingRecipeInput input, @NotNull Level level) {
        boolean vanillaMatches = super.matches(input, level);
        if (!vanillaMatches) {
            return false;
        }
        Item<ItemStack> template = BukkitItemManager.instance().wrap((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)input.template()));
        Item<ItemStack> base = BukkitItemManager.instance().wrap((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)input.base()));
        Item<ItemStack> addition = BukkitItemManager.instance().wrap((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)input.addition()));
        SmithingInput<ItemStack> smithingInput = new SmithingInput<ItemStack>(UniqueIdItem.of(base), UniqueIdItem.of(template), UniqueIdItem.of(addition));
        return this.recipe.matches(smithingInput);
    }

    public boolean showNotification() {
        return this.recipe.showNotification();
    }
}

