/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_21_4.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.momirealms.craftengine.bukkit.api.BukkitAdaptors;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import org.jetbrains.annotations.NotNull;

public class CraftEngineItem
extends LootPoolSingletonContainer {
    public static final MapCodec<CraftEngineItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("name").forGetter(lootItem -> lootItem.name)).and(CraftEngineItem.singletonFields((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, CraftEngineItem::new));
    public static final LootPoolEntryType TYPE = new LootPoolEntryType(CODEC);
    private final ResourceLocation name;

    public CraftEngineItem(ResourceLocation name, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.name = name;
    }

    protected void createItemStack(@NotNull Consumer<ItemStack> consumer, @NotNull LootContext lootContext) {
        Optional optionalCustomItem = BukkitItemManager.instance().getCustomItem(KeyUtils.resourceLocationToKey(this.name));
        if (optionalCustomItem.isEmpty()) {
            return;
        }
        BukkitServerPlayer serverPlayer = null;
        Object object = lootContext.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (object instanceof Player) {
            Player player = (Player)object;
            serverPlayer = BukkitAdaptors.adapt((org.bukkit.entity.Player)player.getBukkitEntity());
        }
        consumer.accept((ItemStack)optionalCustomItem.get().buildItem(serverPlayer).getLiteralObject());
    }

    @NotNull
    public LootPoolEntryType getType() {
        return TYPE;
    }
}

